/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConsumer;
import io.vertx.rabbitmq.impl.RabbitMQConsumerImpl;
import io.vertx.rabbitmq.impl.RabbitMQMessageImpl;

public class QueueConsumerHandler
extends DefaultConsumer {
    private final RabbitMQConsumerImpl queue;
    private final Context handlerContext;
    private Handler<ShutdownSignalException> shutdownHandler;
    private static final Logger log = LoggerFactory.getLogger(QueueConsumerHandler.class);

    QueueConsumerHandler(Vertx vertx, Channel channel, QueueOptions options, String queueName) {
        super(channel);
        this.handlerContext = vertx.getOrCreateContext();
        this.queue = new RabbitMQConsumerImpl(this.handlerContext, this, options, queueName);
    }

    public void setShutdownHandler(Handler<ShutdownSignalException> shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        RabbitMQMessageImpl msg = new RabbitMQMessageImpl(body, consumerTag, envelope, properties, null);
        this.handlerContext.runOnContext(v -> this.queue.handleMessage(msg));
    }

    public void handleConsumeOk(String consumerTag) {
        super.handleConsumeOk(consumerTag);
        log.debug((Object)("Consumer tag is now " + consumerTag));
    }

    public void handleCancel(String consumerTag) {
        log.debug((Object)("consumer has been cancelled unexpectedly: " + consumerTag));
        this.queue.handleEnd();
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        log.debug((Object)("consumer has been shutdown unexpectedly: " + consumerTag));
        if (this.shutdownHandler != null && !this.queue.isCancelled()) {
            this.shutdownHandler.handle((Object)sig);
        }
    }

    public RabbitMQConsumer queue() {
        return this.queue;
    }
}

