package io.vertx.groovy.servicediscovery;
import groovy.lang.MetaMethod;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
public class VertxExtensionModule extends ExtensionModule {
  private static final String extensionClasses = "io.vertx.groovy.servicediscovery.ServiceDiscovery_GroovyExtension, io.vertx.groovy.servicediscovery.spi.ServiceExporter_GroovyExtension, io.vertx.groovy.servicediscovery.spi.ServiceImporter_GroovyExtension, io.vertx.groovy.servicediscovery.spi.ServicePublisher_GroovyExtension, io.vertx.groovy.servicediscovery.ServiceReference_GroovyExtension";
  private static final String staticExtensionClasses = "io.vertx.groovy.servicediscovery.types.EventBusService_GroovyStaticExtension, io.vertx.groovy.servicediscovery.types.HttpEndpoint_GroovyStaticExtension, io.vertx.groovy.servicediscovery.types.JDBCDataSource_GroovyStaticExtension, io.vertx.groovy.servicediscovery.types.MessageSource_GroovyStaticExtension, io.vertx.groovy.servicediscovery.types.MongoDataSource_GroovyStaticExtension, io.vertx.groovy.servicediscovery.types.RedisDataSource_GroovyStaticExtension, io.vertx.groovy.servicediscovery.ServiceDiscovery_GroovyStaticExtension";
  private final ExtensionModule delegate;  public VertxExtensionModule() {
    super("io.vertx.servicediscovery", "3.5.0");
    Properties props = new Properties();
    props.put("moduleName", "io.vertx.servicediscovery");
    props.put("moduleVersion", "3.5.0");
    props.put("extensionClasses", extensionClasses);
    props.put("staticExtensionClasses", staticExtensionClasses);
    delegate = MetaInfExtensionModule.newModule(props, getClass().getClassLoader());
  }
  public List<MetaMethod> getMetaMethods() {
    return delegate.getMetaMethods();
  }
}