/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.servicediscovery.types;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.rxjava.servicediscovery.ServiceDiscovery;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 *  for event bus services (service proxies).
 * Consumers receive a service proxy to use the service.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.EventBusService original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.servicediscovery.types.EventBusService.class)
public class EventBusService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventBusService that = (EventBusService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<EventBusService> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new EventBusService((io.vertx.servicediscovery.types.EventBusService) obj),
    EventBusService::getDelegate
  );

  private final io.vertx.servicediscovery.types.EventBusService delegate;
  
  public EventBusService(io.vertx.servicediscovery.types.EventBusService delegate) {
    this.delegate = delegate;
  }

  public io.vertx.servicediscovery.types.EventBusService getDelegate() {
    return delegate;
  }

  /**
   * Sugar method to creates a record for this type.
   * <p>
   * The java interface is added to the metadata in the `service.interface` key.
   * @param name the name of the service.
   * @param address the event bus address on which the service available
   * @param itf the Java interface (name)
   * @param metadata the metadata
   * @return the created record
   */
  public static Record createRecord(String name, String address, String itf, JsonObject metadata) { 
    Record ret = io.vertx.servicediscovery.types.EventBusService.createRecord(name, address, itf, metadata);
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * @param discovery the service discovery
   * @param filter the filter
   * @param clientClass the client class
   * @param resultHandler the result handler
   * @return <code>null</code> - do not use
   */
  public static <T> T getServiceProxy(ServiceDiscovery discovery, Function<Record,Boolean> filter, Class<T> clientClass, Handler<AsyncResult<T>> resultHandler) { 
    T ret = (T)io.vertx.lang.rxjava.TypeArg.of(clientClass).wrap(io.vertx.servicediscovery.types.EventBusService.getServiceProxy(discovery.getDelegate(), new java.util.function.Function<io.vertx.servicediscovery.Record,java.lang.Boolean>() {
      public java.lang.Boolean apply(io.vertx.servicediscovery.Record arg) {
        Boolean ret = filter.apply(arg);
        return ret;
      }
    }, io.vertx.lang.rxjava.Helper.unwrap(clientClass), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T)io.vertx.lang.rxjava.TypeArg.of(clientClass).wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    }));
    return ret;
  }

  /**
   * Lookup for a service record and if found, retrieve it and return the service object (used to consume the service).
   * This is a convenient method to avoid explicit lookup and then retrieval of the service. This method requires to
   * have the <code>clientClass</code> set with the expected set of client. This is important for usages not using Java so
   * you can pass the expected type.
   * @param discovery the service discovery
   * @param filter the filter as json object
   * @param clientClass the client class
   * @param resultHandler the result handler
   * @return <code>null</code> - do not use
   */
  public static <T> T getServiceProxyWithJsonFilter(ServiceDiscovery discovery, JsonObject filter, Class<T> clientClass, Handler<AsyncResult<T>> resultHandler) { 
    T ret = (T)io.vertx.lang.rxjava.TypeArg.of(clientClass).wrap(io.vertx.servicediscovery.types.EventBusService.getServiceProxyWithJsonFilter(discovery.getDelegate(), filter, io.vertx.lang.rxjava.Helper.unwrap(clientClass), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture((T)io.vertx.lang.rxjava.TypeArg.of(clientClass).wrap(ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    }));
    return ret;
  }

  /**
   * Creates a record based on the parameters.
   * @param name the service name
   * @param address the address
   * @param classname the payload class
   * @return the record
   */
  public static Record createRecord(String name, String address, String classname) { 
    Record ret = io.vertx.servicediscovery.types.EventBusService.createRecord(name, address, classname);
    return ret;
  }


  public static  EventBusService newInstance(io.vertx.servicediscovery.types.EventBusService arg) {
    return arg != null ? new EventBusService(arg) : null;
  }
}
