/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.impl.Origin;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.Utils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class CorsHandlerImpl
implements CorsHandler {
    private final Pattern allowedOrigin;
    private Set<Origin> allowedOrigins;
    private String allowedMethodsString;
    private String allowedHeadersString;
    private String exposedHeadersString;
    private boolean allowCredentials;
    private String maxAgeSeconds;
    private final Set<String> allowedMethods = new LinkedHashSet<String>();
    private final Set<String> allowedHeaders = new LinkedHashSet<String>();
    private final Set<String> exposedHeaders = new LinkedHashSet<String>();

    public CorsHandlerImpl(String allowedOriginPattern) {
        Objects.requireNonNull(allowedOriginPattern);
        this.allowedOrigin = "*".equals(allowedOriginPattern) ? null : Pattern.compile(allowedOriginPattern);
        this.allowedOrigins = null;
    }

    public CorsHandlerImpl() {
        this.allowedOrigin = null;
        this.allowedOrigins = null;
    }

    @Override
    public CorsHandler addOrigin(String origin) {
        if (this.allowedOrigin != null) {
            throw new IllegalStateException("Cannot mix Pattern mode and Origin List mode");
        }
        if (this.allowedOrigins == null) {
            if (origin.equals("*")) {
                return this;
            }
            this.allowedOrigins = new LinkedHashSet<Origin>();
        } else if (origin.equals("*")) {
            throw new IllegalStateException("Cannot mix '*' with explicit origins");
        }
        this.allowedOrigins.add(Origin.parse(origin));
        return this;
    }

    @Override
    public CorsHandler addOrigins(List<String> origins) {
        if (this.allowedOrigin != null) {
            throw new IllegalStateException("Cannot mix Pattern mode and Origin List mode");
        }
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new LinkedHashSet<Origin>();
        }
        for (String origin : origins) {
            this.allowedOrigins.add(Origin.parse(origin));
        }
        return this;
    }

    @Override
    public CorsHandler allowedMethod(HttpMethod method) {
        this.allowedMethods.add(method.name());
        this.allowedMethodsString = String.join((CharSequence)",", this.allowedMethods);
        return this;
    }

    @Override
    public CorsHandler allowedMethods(Set<HttpMethod> methods) {
        for (HttpMethod method : methods) {
            this.allowedMethods.add(method.name());
        }
        this.allowedMethodsString = String.join((CharSequence)",", this.allowedMethods);
        return this;
    }

    @Override
    public CorsHandler allowedHeader(String headerName) {
        this.allowedHeaders.add(headerName);
        this.allowedHeadersString = String.join((CharSequence)",", this.allowedHeaders);
        return this;
    }

    @Override
    public CorsHandler allowedHeaders(Set<String> headerNames) {
        this.allowedHeaders.addAll(headerNames);
        this.allowedHeadersString = String.join((CharSequence)",", this.allowedHeaders);
        return this;
    }

    @Override
    public CorsHandler exposedHeader(String headerName) {
        this.exposedHeaders.add(headerName);
        this.exposedHeadersString = String.join((CharSequence)",", this.exposedHeaders);
        return this;
    }

    @Override
    public CorsHandler exposedHeaders(Set<String> headerNames) {
        this.exposedHeaders.addAll(headerNames);
        this.exposedHeadersString = String.join((CharSequence)",", this.exposedHeaders);
        return this;
    }

    @Override
    public CorsHandler allowCredentials(boolean allow) {
        this.allowCredentials = allow;
        return this;
    }

    @Override
    public CorsHandler maxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds == -1 ? null : String.valueOf(maxAgeSeconds);
        return this;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        String origin = context.request().headers().get(HttpHeaders.ORIGIN);
        if (origin == null) {
            Utils.appendToMapIfAbsent(response.headers(), HttpHeaders.VARY, ",", HttpHeaders.ORIGIN);
            context.next();
        } else if (this.isValidOrigin(origin)) {
            String accessControlRequestMethod = request.headers().get(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (request.method() == HttpMethod.OPTIONS && accessControlRequestMethod != null) {
                this.addCredentialsAndOriginHeader(response, origin);
                if (this.allowedMethodsString != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)this.allowedMethodsString);
                }
                if (this.allowedHeadersString != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)this.allowedHeadersString);
                } else if (request.headers().contains(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS));
                    Utils.appendToMapIfAbsent(response.headers(), HttpHeaders.VARY, ",", HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS);
                }
                if (this.maxAgeSeconds != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)this.maxAgeSeconds);
                }
                response.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)"0").setStatusCode(204).end();
            } else {
                Utils.appendToMapIfAbsent(response.headers(), HttpHeaders.VARY, ",", HttpHeaders.ORIGIN);
                this.addCredentialsAndOriginHeader(response, origin);
                if (this.exposedHeadersString != null) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)this.exposedHeadersString);
                }
                ((RoutingContextInternal)context).visitHandler(4);
                context.next();
            }
        } else {
            context.response().setStatusMessage("CORS Rejected - Invalid origin");
            context.fail(403);
        }
    }

    private void addCredentialsAndOriginHeader(HttpServerResponse response, String origin) {
        if (this.allowCredentials) {
            response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
            response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
        } else {
            response.putHeader(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)this.getAllowedOrigin(origin));
        }
    }

    private boolean isValidOrigin(String origin) {
        if (this.allowedOrigin == null && this.allowedOrigins == null) {
            return Origin.isValid(origin);
        }
        if (this.allowedOrigin != null) {
            return this.allowedOrigin.matcher(origin).matches();
        }
        for (Origin allowedOrigin : this.allowedOrigins) {
            if (!allowedOrigin.sameOrigin(origin)) continue;
            return true;
        }
        return false;
    }

    private String getAllowedOrigin(String origin) {
        if (this.allowedOrigin == null && this.allowedOrigins == null) {
            return "*";
        }
        return origin;
    }
}

