/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem.junit;

import com.google.common.collect.ImmutableList;
import io.wcm.testing.junit.rules.parameterized.Callback;
import io.wcm.testing.junit.rules.parameterized.ListGenerator;
import io.wcm.testing.mock.aem.context.AemContextImpl;
import io.wcm.testing.mock.aem.junit.AemContextCallback;
import java.util.List;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class AemContext
extends AemContextImpl
implements TestRule {
    private final AemContextCallback setUpCallback;
    private final AemContextCallback tearDownCallback;
    private final ResourceResolverType[] resourceResolverTypes;
    private final TestRule delegate;

    public AemContext(ResourceResolverType ... resourceResolverTypes) {
        this((AemContextCallback)null, (AemContextCallback)null, resourceResolverTypes);
    }

    public AemContext(AemContextCallback setUpCallback, ResourceResolverType ... resourceResolverTypes) {
        this(setUpCallback, (AemContextCallback)null, resourceResolverTypes);
    }

    public AemContext(AemContextCallback setUpCallback, AemContextCallback tearDownCallback, ResourceResolverType ... resourceResolverTypes) {
        this.setUpCallback = setUpCallback;
        this.tearDownCallback = tearDownCallback;
        this.resourceResolverTypes = resourceResolverTypes == null || resourceResolverTypes.length == 0 ? new ResourceResolverType[]{MockSling.DEFAULT_RESOURCERESOLVER_TYPE} : resourceResolverTypes;
        if (this.resourceResolverTypes.length == 1) {
            this.setResourceResolverType(this.resourceResolverTypes[0]);
            this.delegate = new ExternalResource(){

                protected void before() {
                    AemContext.this.setUp();
                    AemContext.this.executeSetUpCallback();
                }

                protected void after() {
                    AemContext.this.executeTearDownCallback();
                    AemContext.this.tearDown();
                }
            };
        } else {
            Callback<ResourceResolverType> parameterizedSetUpCallback = new Callback<ResourceResolverType>(){

                public void execute(ResourceResolverType currrentValue) {
                    AemContext.this.setResourceResolverType(currrentValue);
                    AemContext.this.setUp();
                    AemContext.this.executeSetUpCallback();
                }
            };
            Callback<ResourceResolverType> parameterizedTearDownCallback = new Callback<ResourceResolverType>(){

                public void execute(ResourceResolverType currrentValue) {
                    AemContext.this.executeTearDownCallback();
                    AemContext.this.tearDown();
                }
            };
            this.delegate = new ListGenerator((List)ImmutableList.copyOf((Object[])this.resourceResolverTypes), (Callback)parameterizedSetUpCallback, (Callback)parameterizedTearDownCallback);
        }
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }

    private void executeSetUpCallback() {
        if (this.setUpCallback != null) {
            try {
                this.setUpCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Setup failed: " + ex.getMessage(), ex);
            }
        }
    }

    private void executeTearDownCallback() {
        if (this.tearDownCallback != null) {
            try {
                this.tearDownCallback.execute(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Teardown failed: " + ex.getMessage(), ex);
            }
        }
    }
}

