/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.configuration;

import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;

public class EmailEmbeddedRedis {
    private static final Logger log = LoggerFactory.getLogger(EmailEmbeddedRedis.class);
    private static final Character WHITESPACE = Character.valueOf(' ');
    private final int redisPort;
    private final Set<String> settings;
    private final RedisServer redisServer;

    public EmailEmbeddedRedis(int redisPort, @NonNull Set<String> settings) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.redisPort = redisPort;
        this.settings = this.mergeSettings(settings);
        this.redisServer = this.createRedisServer();
    }

    private RedisServer createRedisServer() {
        RedisServerBuilder redisServerBuilder = RedisServer.builder().port(this.redisPort).setting("appendonly yes").setting("appendfsync everysec");
        this.settings.stream().forEach(s -> redisServerBuilder.setting(s));
        RedisServer redisServer = redisServerBuilder.build();
        return redisServer;
    }

    public EmailEmbeddedRedis start() {
        log.info("Started Embedded Redis Server on port {}.", (Object)this.redisPort);
        this.redisServer.start();
        return this;
    }

    @PreDestroy
    public void stopRedis() {
        this.redisServer.stop();
        log.info("Stopped Embedded Redis Server on port {}.", (Object)this.redisPort);
    }

    public boolean isActive() {
        return this.redisServer.isActive();
    }

    private Set<String> mergeSettings(Set<String> settings) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        keyValueMap.put("appendonly", "yes");
        keyValueMap.put("appendfsync", "everysec");
        for (String setting : settings) {
            String normalizedSetting = setting.trim();
            int indexOfWhitespace = normalizedSetting.indexOf(WHITESPACE.charValue());
            if (indexOfWhitespace == -1 || indexOfWhitespace == normalizedSetting.length()) continue;
            String key = normalizedSetting.substring(0, indexOfWhitespace);
            String value = normalizedSetting.substring(indexOfWhitespace + 1).trim();
            keyValueMap.put(key, value);
        }
        return keyValueMap.entrySet().stream().map(entry -> (String)entry.getKey() + WHITESPACE + (String)entry.getValue()).collect(Collectors.toSet());
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public Set<String> getSettings() {
        return this.settings;
    }
}

