/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.configuration;

import it.ozimov.springboot.mail.configuration.EmailEmbeddedRedis;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisShardInfo;

@Configuration
@ConditionalOnExpression(value="'${spring.mail.scheduler.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.redis.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.redis.embedded:false}' == 'true'")
public class EmailEmbeddedRedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmailEmbeddedRedisConfiguration.class);
    private static final String REDIS_PORT = "${spring.mail.scheduler.persistence.redis.port}";
    private static final String REDIS_SETTINGS = "#{'${spring.mail.scheduler.persistence.redis.settings:appendonly yes,appendfsync everysec}'.split(',')}";
    private EmailEmbeddedRedis emailEmbeddedRedis;
    private JedisConnectionFactory connectionFactory;

    public EmailEmbeddedRedisConfiguration(@Value(value="${spring.mail.scheduler.persistence.redis.port}") int redisPort, @Value(value="#{'${spring.mail.scheduler.persistence.redis.settings:appendonly yes,appendfsync everysec}'.split(',')}") List<String> redisSettings) {
        this.emailEmbeddedRedis = new EmailEmbeddedRedis(redisPort, redisSettings.stream().map(s -> s.trim()).collect(Collectors.toSet())).start();
        JedisShardInfo shardInfo = new JedisShardInfo("localhost", redisPort);
        this.connectionFactory = new JedisConnectionFactory();
        this.connectionFactory.setShardInfo(shardInfo);
        this.connectionFactory.setUsePool(true);
        this.connectionFactory.getPoolConfig().setMaxTotal(10000);
    }

    @Bean
    @ConditionalOnExpression(value="'${spring.mail.scheduler.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.redis.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.redis.embedded:false}' == 'true'")
    public EmailEmbeddedRedis emailEmbeddedRedis() {
        return this.emailEmbeddedRedis;
    }

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        return this.connectionFactory;
    }

    @PreDestroy
    public void preDestroy() {
        this.emailEmbeddedRedis.stopRedis();
        log.info("Destroying Jedis connection factory on host {} and port {}.", (Object)this.connectionFactory.getHostName(), (Object)this.connectionFactory.getPort());
        this.connectionFactory.destroy();
        log.info("Destroyed Jedis connection factory on host {} and port {}.", (Object)this.connectionFactory.getHostName(), (Object)this.connectionFactory.getPort());
    }
}

