/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.configuration;

import it.ozimov.springboot.mail.model.EmailSchedulingData;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@ConditionalOnExpression(value="'${spring.mail.scheduler.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.redis.enabled:false}' == 'true'")
public class EmailRedisTemplateConfiguration {
    private final RedisConnectionFactory redisConnectionFactory;

    @Autowired
    public EmailRedisTemplateConfiguration(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    @Bean
    @Qualifier(value="orderingTemplate")
    public StringRedisTemplate createOrderingTemplate() throws IOException {
        StringRedisTemplate template = new StringRedisTemplate(this.redisConnectionFactory);
        template.setEnableTransactionSupport(true);
        return template;
    }

    @Bean
    @Qualifier(value="valueTemplate")
    public RedisTemplate<String, EmailSchedulingData> createValueTemplate() throws IOException {
        RedisTemplate template = new RedisTemplate();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringSerializer);
        template.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringSerializer);
        template.setHashValueSerializer((RedisSerializer)stringSerializer);
        template.setConnectionFactory(this.redisConnectionFactory);
        template.setEnableTransactionSupport(true);
        template.afterPropertiesSet();
        return template;
    }
}

