/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.configuration;

import com.google.common.annotations.VisibleForTesting;
import it.ozimov.springboot.mail.configuration.LoggingProperties;
import it.ozimov.springboot.mail.logging.EmailRenderer;
import it.ozimov.springboot.mail.logging.defaultimpl.CustomizableEmailRenderer;
import it.ozimov.springboot.mail.logging.defaultimpl.EmailFieldFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.mail.internet.InternetAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${spring.mail.logging.enabled:true}' == 'true'")
public class EmailRendererConfiguration {
    private final LoggingProperties loggingProperties;

    @Autowired
    public EmailRendererConfiguration(LoggingProperties loggingProperties) {
        this.loggingProperties = loggingProperties;
    }

    @Bean
    public EmailRenderer emailRenderer() {
        Function<InternetAddress, String> depositionNotificationToFormat;
        Function<InternetAddress, String> receiptToFormat;
        Function<Date, String> sentAtFormat;
        Function<Locale, String> localeFormat;
        UnaryOperator<String> encodingFormat;
        UnaryOperator<String> attachmentsFormat;
        UnaryOperator<String> bodyFormat;
        UnaryOperator<String> subjectFormat;
        Function<InternetAddress, String> bccFormat;
        Function<InternetAddress, String> ccFormat;
        Function<InternetAddress, String> toFormat;
        Function<InternetAddress, String> replyToFormat;
        CustomizableEmailRenderer.CustomizableEmailRendererBuilder customizableEmailRendererBuilder = this.createCustomizableEmailRendererBuilder();
        LoggingProperties.Strategy loggingPropertiesStrategy = this.loggingProperties.getStrategy();
        Function<InternetAddress, String> fromFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getFrom());
        if (Objects.nonNull(fromFormat)) {
            customizableEmailRendererBuilder.withFromFormat(fromFormat);
        }
        if (Objects.nonNull(replyToFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getReplyTo()))) {
            customizableEmailRendererBuilder.withReplyToFormat(replyToFormat);
        }
        if (Objects.nonNull(toFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getTo()))) {
            customizableEmailRendererBuilder.withToFormat(toFormat);
        }
        if (Objects.nonNull(ccFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getCc()))) {
            customizableEmailRendererBuilder.withCcFormat(ccFormat);
        }
        if (Objects.nonNull(bccFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getBcc()))) {
            customizableEmailRendererBuilder.withBccFormat(bccFormat);
        }
        if (Objects.nonNull(subjectFormat = EmailFieldFormat.textFormatterFrom(loggingPropertiesStrategy.getSubject()))) {
            customizableEmailRendererBuilder.withSubjectFormat(subjectFormat);
        }
        if (Objects.nonNull(bodyFormat = EmailFieldFormat.textFormatterFrom(loggingPropertiesStrategy.getBody()))) {
            customizableEmailRendererBuilder.withBodyFormat(bodyFormat);
        }
        if (Objects.nonNull(attachmentsFormat = EmailFieldFormat.textFormatterFrom(loggingPropertiesStrategy.getAttachments()))) {
            customizableEmailRendererBuilder.withAttachmentsFormat(attachmentsFormat);
        }
        if (Objects.nonNull(encodingFormat = EmailFieldFormat.textFormatterFrom(loggingPropertiesStrategy.getEncoding()))) {
            customizableEmailRendererBuilder.withEncodingFormat(encodingFormat);
        }
        if (Objects.nonNull(localeFormat = EmailFieldFormat.localeFormatterFrom(loggingPropertiesStrategy.getLocale()))) {
            customizableEmailRendererBuilder.withLocaleFormat(localeFormat);
        }
        if (Objects.nonNull(sentAtFormat = EmailFieldFormat.dateFormatterFrom(loggingPropertiesStrategy.getSentAt()))) {
            customizableEmailRendererBuilder.withSentAtFormat(sentAtFormat);
        }
        if (Objects.nonNull(receiptToFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getReceiptTo()))) {
            customizableEmailRendererBuilder.withReceiptToFormat(receiptToFormat);
        }
        if (Objects.nonNull(depositionNotificationToFormat = EmailFieldFormat.emailFormatterFrom(loggingPropertiesStrategy.getDepositionNotificationTo()))) {
            customizableEmailRendererBuilder.withDepositionNotificationToFormat(depositionNotificationToFormat);
        }
        if (!loggingPropertiesStrategy.areCustomHeadersIgnored()) {
            customizableEmailRendererBuilder.includeCustomHeaders();
        }
        if (!loggingPropertiesStrategy.areNullAndEmptyCollectionsIgnored()) {
            customizableEmailRendererBuilder.includeNullAndEmptyCollections();
        }
        return customizableEmailRendererBuilder.build();
    }

    @VisibleForTesting
    protected CustomizableEmailRenderer.CustomizableEmailRendererBuilder createCustomizableEmailRendererBuilder() {
        return CustomizableEmailRenderer.builder();
    }
}

