/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.configuration;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Objects;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.mail.scheduler")
public class EmailSchedulerProperties {
    private boolean enabled;
    private Integer priorityLevels = 10;
    private Persistence persistence = new Persistence();

    @PostConstruct
    protected boolean validate() {
        if (this.enabled) {
            EmailSchedulerProperties.checkIsValid(this);
        } else {
            this.setValuesToNull();
        }
        return true;
    }

    public static void checkIsValid(@NonNull EmailSchedulerProperties emailSchedulerProperties) {
        if (emailSchedulerProperties == null) {
            throw new NullPointerException("emailSchedulerProperties");
        }
        Preconditions.checkState((emailSchedulerProperties.getPriorityLevels() > 0 ? 1 : 0) != 0, (Object)"Expected at least one priority level. Review property 'spring.mail.scheduler.priorityLevels'.");
        Preconditions.checkState((Objects.isNull(emailSchedulerProperties.getPersistence()) || emailSchedulerProperties.getPersistence().getDesiredBatchSize() > 0 ? 1 : 0) != 0, (Object)"Expected at least a batch of size one, otherwise the persistence layer will not work. Review property 'spring.mail.scheduler.persistence.desiredBatchSize'.");
        Preconditions.checkState((Objects.isNull(emailSchedulerProperties.getPersistence()) || emailSchedulerProperties.getPersistence().getMinKeptInMemory() >= 0 ? 1 : 0) != 0, (Object)"Expected a non negative amount of email to be kept in memory. Review property 'spring.mail.scheduler.persistence.minKeptInMemory'.");
        Preconditions.checkState((Objects.isNull(emailSchedulerProperties.getPersistence()) || emailSchedulerProperties.getPersistence().getMaxKeptInMemory() > 0 ? 1 : 0) != 0, (Object)"Expected at least one email to be available in memory, otherwise the persistence layer will not work. Review property 'spring.mail.scheduler.persistence.maxKeptInMemory'.");
        Preconditions.checkState((Objects.isNull(emailSchedulerProperties.getPersistence()) || emailSchedulerProperties.getPersistence().getMaxKeptInMemory() >= emailSchedulerProperties.getPersistence().getMinKeptInMemory() ? 1 : 0) != 0, (String)"The application properties key '%s' should not have a value smaller than the value in property '%s'.", (Object)"spring.mail.scheduler.persistence.maxKeptInMemory", (Object)"spring.mail.scheduler.persistence.minKeptInMemory");
        Preconditions.checkState((Objects.isNull(emailSchedulerProperties.getPersistence()) || emailSchedulerProperties.getPersistence().getMaxKeptInMemory() >= emailSchedulerProperties.getPersistence().getDesiredBatchSize() ? 1 : 0) != 0, (String)"The application properties key '%s' should not have a value smaller than the value in property '%s'.", (Object)"spring.mail.scheduler.persistence.maxKeptInMemory", (Object)"spring.mail.scheduler.persistence.desiredBatchSize");
    }

    private void setValuesToNull() {
        this.priorityLevels = null;
        this.persistence = null;
    }

    public static EmailSchedulerPropertiesBuilder builder() {
        return new EmailSchedulerPropertiesBuilder();
    }

    public Integer getPriorityLevels() {
        return this.priorityLevels;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPriorityLevels(Integer priorityLevels) {
        this.priorityLevels = priorityLevels;
    }

    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmailSchedulerProperties)) {
            return false;
        }
        EmailSchedulerProperties other = (EmailSchedulerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        Integer this$priorityLevels = this.getPriorityLevels();
        Integer other$priorityLevels = other.getPriorityLevels();
        if (this$priorityLevels == null ? other$priorityLevels != null : !((Object)this$priorityLevels).equals(other$priorityLevels)) {
            return false;
        }
        Persistence this$persistence = this.getPersistence();
        Persistence other$persistence = other.getPersistence();
        return !(this$persistence == null ? other$persistence != null : !((Object)this$persistence).equals(other$persistence));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmailSchedulerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enabled ? 79 : 97);
        Integer $priorityLevels = this.getPriorityLevels();
        result = result * 59 + ($priorityLevels == null ? 43 : ((Object)$priorityLevels).hashCode());
        Persistence $persistence = this.getPersistence();
        result = result * 59 + ($persistence == null ? 43 : ((Object)$persistence).hashCode());
        return result;
    }

    public String toString() {
        return "EmailSchedulerProperties(enabled=" + this.enabled + ", priorityLevels=" + this.getPriorityLevels() + ", persistence=" + this.getPersistence() + ")";
    }

    public EmailSchedulerProperties() {
    }

    @ConstructorProperties(value={"enabled", "priorityLevels", "persistence"})
    public EmailSchedulerProperties(boolean enabled, Integer priorityLevels, Persistence persistence) {
        this.enabled = enabled;
        this.priorityLevels = priorityLevels;
        this.persistence = persistence;
    }

    public static class EmailSchedulerPropertiesBuilder {
        private boolean enabled;
        private Integer priorityLevels;
        private Persistence persistence;

        EmailSchedulerPropertiesBuilder() {
        }

        public EmailSchedulerPropertiesBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public EmailSchedulerPropertiesBuilder priorityLevels(Integer priorityLevels) {
            this.priorityLevels = priorityLevels;
            return this;
        }

        public EmailSchedulerPropertiesBuilder persistence(Persistence persistence) {
            this.persistence = persistence;
            return this;
        }

        public EmailSchedulerProperties build() {
            return new EmailSchedulerProperties(this.enabled, this.priorityLevels, this.persistence);
        }

        public String toString() {
            return "EmailSchedulerProperties.EmailSchedulerPropertiesBuilder(enabled=" + this.enabled + ", priorityLevels=" + this.priorityLevels + ", persistence=" + this.persistence + ")";
        }
    }

    public static class Persistence {
        private int desiredBatchSize = 500;
        private int minKeptInMemory = 250;
        private int maxKeptInMemory = 2000;

        public static PersistenceBuilder builder() {
            return new PersistenceBuilder();
        }

        public int getDesiredBatchSize() {
            return this.desiredBatchSize;
        }

        public int getMinKeptInMemory() {
            return this.minKeptInMemory;
        }

        public int getMaxKeptInMemory() {
            return this.maxKeptInMemory;
        }

        public void setDesiredBatchSize(int desiredBatchSize) {
            this.desiredBatchSize = desiredBatchSize;
        }

        public void setMinKeptInMemory(int minKeptInMemory) {
            this.minKeptInMemory = minKeptInMemory;
        }

        public void setMaxKeptInMemory(int maxKeptInMemory) {
            this.maxKeptInMemory = maxKeptInMemory;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Persistence)) {
                return false;
            }
            Persistence other = (Persistence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDesiredBatchSize() != other.getDesiredBatchSize()) {
                return false;
            }
            if (this.getMinKeptInMemory() != other.getMinKeptInMemory()) {
                return false;
            }
            return this.getMaxKeptInMemory() == other.getMaxKeptInMemory();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Persistence;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDesiredBatchSize();
            result = result * 59 + this.getMinKeptInMemory();
            result = result * 59 + this.getMaxKeptInMemory();
            return result;
        }

        public String toString() {
            return "EmailSchedulerProperties.Persistence(desiredBatchSize=" + this.getDesiredBatchSize() + ", minKeptInMemory=" + this.getMinKeptInMemory() + ", maxKeptInMemory=" + this.getMaxKeptInMemory() + ")";
        }

        public Persistence() {
        }

        @ConstructorProperties(value={"desiredBatchSize", "minKeptInMemory", "maxKeptInMemory"})
        public Persistence(int desiredBatchSize, int minKeptInMemory, int maxKeptInMemory) {
            this.desiredBatchSize = desiredBatchSize;
            this.minKeptInMemory = minKeptInMemory;
            this.maxKeptInMemory = maxKeptInMemory;
        }

        public static class PersistenceBuilder {
            private int desiredBatchSize;
            private int minKeptInMemory;
            private int maxKeptInMemory;

            PersistenceBuilder() {
            }

            public PersistenceBuilder desiredBatchSize(int desiredBatchSize) {
                this.desiredBatchSize = desiredBatchSize;
                return this;
            }

            public PersistenceBuilder minKeptInMemory(int minKeptInMemory) {
                this.minKeptInMemory = minKeptInMemory;
                return this;
            }

            public PersistenceBuilder maxKeptInMemory(int maxKeptInMemory) {
                this.maxKeptInMemory = maxKeptInMemory;
                return this;
            }

            public Persistence build() {
                return new Persistence(this.desiredBatchSize, this.minKeptInMemory, this.maxKeptInMemory);
            }

            public String toString() {
                return "EmailSchedulerProperties.Persistence.PersistenceBuilder(desiredBatchSize=" + this.desiredBatchSize + ", minKeptInMemory=" + this.minKeptInMemory + ", maxKeptInMemory=" + this.maxKeptInMemory + ")";
            }
        }
    }
}

