/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.configuration;

import it.ozimov.springboot.mail.logging.LoggingStrategy;
import java.beans.ConstructorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.mail.logging")
public class LoggingProperties {
    private boolean enabled = true;
    private Strategy strategy = new Strategy();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggingProperties)) {
            return false;
        }
        LoggingProperties other = (LoggingProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        return !(this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoggingProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)$strategy).hashCode());
        return result;
    }

    public String toString() {
        return "LoggingProperties(enabled=" + this.isEnabled() + ", strategy=" + this.getStrategy() + ")";
    }

    public LoggingProperties() {
    }

    @ConstructorProperties(value={"enabled", "strategy"})
    public LoggingProperties(boolean enabled, Strategy strategy) {
        this.enabled = enabled;
        this.strategy = strategy;
    }

    public static class Strategy {
        private LoggingStrategy from = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy replyTo = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy to = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy cc = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy bcc = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy subject = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy body = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy attachments = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy encoding = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy locale = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy sentAt = LoggingStrategy.STANDARD_DATE_FORMAT;
        private LoggingStrategy receiptTo = LoggingStrategy.PLAIN_TEXT;
        private LoggingStrategy depositionNotificationTo = LoggingStrategy.PLAIN_TEXT;
        private Ignore ignore = new Ignore();

        public boolean areCustomHeadersIgnored() {
            return this.ignore.customHeaders;
        }

        public boolean areNullAndEmptyCollectionsIgnored() {
            return this.ignore.nullAndEmptyCollections;
        }

        public LoggingStrategy getFrom() {
            return this.from;
        }

        public LoggingStrategy getReplyTo() {
            return this.replyTo;
        }

        public LoggingStrategy getTo() {
            return this.to;
        }

        public LoggingStrategy getCc() {
            return this.cc;
        }

        public LoggingStrategy getBcc() {
            return this.bcc;
        }

        public LoggingStrategy getSubject() {
            return this.subject;
        }

        public LoggingStrategy getBody() {
            return this.body;
        }

        public LoggingStrategy getAttachments() {
            return this.attachments;
        }

        public LoggingStrategy getEncoding() {
            return this.encoding;
        }

        public LoggingStrategy getLocale() {
            return this.locale;
        }

        public LoggingStrategy getSentAt() {
            return this.sentAt;
        }

        public LoggingStrategy getReceiptTo() {
            return this.receiptTo;
        }

        public LoggingStrategy getDepositionNotificationTo() {
            return this.depositionNotificationTo;
        }

        public void setFrom(LoggingStrategy from) {
            this.from = from;
        }

        public void setReplyTo(LoggingStrategy replyTo) {
            this.replyTo = replyTo;
        }

        public void setTo(LoggingStrategy to) {
            this.to = to;
        }

        public void setCc(LoggingStrategy cc) {
            this.cc = cc;
        }

        public void setBcc(LoggingStrategy bcc) {
            this.bcc = bcc;
        }

        public void setSubject(LoggingStrategy subject) {
            this.subject = subject;
        }

        public void setBody(LoggingStrategy body) {
            this.body = body;
        }

        public void setAttachments(LoggingStrategy attachments) {
            this.attachments = attachments;
        }

        public void setEncoding(LoggingStrategy encoding) {
            this.encoding = encoding;
        }

        public void setLocale(LoggingStrategy locale) {
            this.locale = locale;
        }

        public void setSentAt(LoggingStrategy sentAt) {
            this.sentAt = sentAt;
        }

        public void setReceiptTo(LoggingStrategy receiptTo) {
            this.receiptTo = receiptTo;
        }

        public void setDepositionNotificationTo(LoggingStrategy depositionNotificationTo) {
            this.depositionNotificationTo = depositionNotificationTo;
        }

        public void setIgnore(Ignore ignore) {
            this.ignore = ignore;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Strategy)) {
                return false;
            }
            Strategy other = (Strategy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoggingStrategy this$from = this.getFrom();
            LoggingStrategy other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)((Object)this$from)).equals((Object)other$from)) {
                return false;
            }
            LoggingStrategy this$replyTo = this.getReplyTo();
            LoggingStrategy other$replyTo = other.getReplyTo();
            if (this$replyTo == null ? other$replyTo != null : !((Object)((Object)this$replyTo)).equals((Object)other$replyTo)) {
                return false;
            }
            LoggingStrategy this$to = this.getTo();
            LoggingStrategy other$to = other.getTo();
            if (this$to == null ? other$to != null : !((Object)((Object)this$to)).equals((Object)other$to)) {
                return false;
            }
            LoggingStrategy this$cc = this.getCc();
            LoggingStrategy other$cc = other.getCc();
            if (this$cc == null ? other$cc != null : !((Object)((Object)this$cc)).equals((Object)other$cc)) {
                return false;
            }
            LoggingStrategy this$bcc = this.getBcc();
            LoggingStrategy other$bcc = other.getBcc();
            if (this$bcc == null ? other$bcc != null : !((Object)((Object)this$bcc)).equals((Object)other$bcc)) {
                return false;
            }
            LoggingStrategy this$subject = this.getSubject();
            LoggingStrategy other$subject = other.getSubject();
            if (this$subject == null ? other$subject != null : !((Object)((Object)this$subject)).equals((Object)other$subject)) {
                return false;
            }
            LoggingStrategy this$body = this.getBody();
            LoggingStrategy other$body = other.getBody();
            if (this$body == null ? other$body != null : !((Object)((Object)this$body)).equals((Object)other$body)) {
                return false;
            }
            LoggingStrategy this$attachments = this.getAttachments();
            LoggingStrategy other$attachments = other.getAttachments();
            if (this$attachments == null ? other$attachments != null : !((Object)((Object)this$attachments)).equals((Object)other$attachments)) {
                return false;
            }
            LoggingStrategy this$encoding = this.getEncoding();
            LoggingStrategy other$encoding = other.getEncoding();
            if (this$encoding == null ? other$encoding != null : !((Object)((Object)this$encoding)).equals((Object)other$encoding)) {
                return false;
            }
            LoggingStrategy this$locale = this.getLocale();
            LoggingStrategy other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !((Object)((Object)this$locale)).equals((Object)other$locale)) {
                return false;
            }
            LoggingStrategy this$sentAt = this.getSentAt();
            LoggingStrategy other$sentAt = other.getSentAt();
            if (this$sentAt == null ? other$sentAt != null : !((Object)((Object)this$sentAt)).equals((Object)other$sentAt)) {
                return false;
            }
            LoggingStrategy this$receiptTo = this.getReceiptTo();
            LoggingStrategy other$receiptTo = other.getReceiptTo();
            if (this$receiptTo == null ? other$receiptTo != null : !((Object)((Object)this$receiptTo)).equals((Object)other$receiptTo)) {
                return false;
            }
            LoggingStrategy this$depositionNotificationTo = this.getDepositionNotificationTo();
            LoggingStrategy other$depositionNotificationTo = other.getDepositionNotificationTo();
            if (this$depositionNotificationTo == null ? other$depositionNotificationTo != null : !((Object)((Object)this$depositionNotificationTo)).equals((Object)other$depositionNotificationTo)) {
                return false;
            }
            Ignore this$ignore = this.ignore;
            Ignore other$ignore = other.ignore;
            return !(this$ignore == null ? other$ignore != null : !((Object)this$ignore).equals(other$ignore));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Strategy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoggingStrategy $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)((Object)$from)).hashCode());
            LoggingStrategy $replyTo = this.getReplyTo();
            result = result * 59 + ($replyTo == null ? 43 : ((Object)((Object)$replyTo)).hashCode());
            LoggingStrategy $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)((Object)$to)).hashCode());
            LoggingStrategy $cc = this.getCc();
            result = result * 59 + ($cc == null ? 43 : ((Object)((Object)$cc)).hashCode());
            LoggingStrategy $bcc = this.getBcc();
            result = result * 59 + ($bcc == null ? 43 : ((Object)((Object)$bcc)).hashCode());
            LoggingStrategy $subject = this.getSubject();
            result = result * 59 + ($subject == null ? 43 : ((Object)((Object)$subject)).hashCode());
            LoggingStrategy $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : ((Object)((Object)$body)).hashCode());
            LoggingStrategy $attachments = this.getAttachments();
            result = result * 59 + ($attachments == null ? 43 : ((Object)((Object)$attachments)).hashCode());
            LoggingStrategy $encoding = this.getEncoding();
            result = result * 59 + ($encoding == null ? 43 : ((Object)((Object)$encoding)).hashCode());
            LoggingStrategy $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : ((Object)((Object)$locale)).hashCode());
            LoggingStrategy $sentAt = this.getSentAt();
            result = result * 59 + ($sentAt == null ? 43 : ((Object)((Object)$sentAt)).hashCode());
            LoggingStrategy $receiptTo = this.getReceiptTo();
            result = result * 59 + ($receiptTo == null ? 43 : ((Object)((Object)$receiptTo)).hashCode());
            LoggingStrategy $depositionNotificationTo = this.getDepositionNotificationTo();
            result = result * 59 + ($depositionNotificationTo == null ? 43 : ((Object)((Object)$depositionNotificationTo)).hashCode());
            Ignore $ignore = this.ignore;
            result = result * 59 + ($ignore == null ? 43 : ((Object)$ignore).hashCode());
            return result;
        }

        public String toString() {
            return "LoggingProperties.Strategy(from=" + (Object)((Object)this.getFrom()) + ", replyTo=" + (Object)((Object)this.getReplyTo()) + ", to=" + (Object)((Object)this.getTo()) + ", cc=" + (Object)((Object)this.getCc()) + ", bcc=" + (Object)((Object)this.getBcc()) + ", subject=" + (Object)((Object)this.getSubject()) + ", body=" + (Object)((Object)this.getBody()) + ", attachments=" + (Object)((Object)this.getAttachments()) + ", encoding=" + (Object)((Object)this.getEncoding()) + ", locale=" + (Object)((Object)this.getLocale()) + ", sentAt=" + (Object)((Object)this.getSentAt()) + ", receiptTo=" + (Object)((Object)this.getReceiptTo()) + ", depositionNotificationTo=" + (Object)((Object)this.getDepositionNotificationTo()) + ", ignore=" + this.ignore + ")";
        }

        public Strategy() {
        }

        @ConstructorProperties(value={"from", "replyTo", "to", "cc", "bcc", "subject", "body", "attachments", "encoding", "locale", "sentAt", "receiptTo", "depositionNotificationTo", "ignore"})
        public Strategy(LoggingStrategy from, LoggingStrategy replyTo, LoggingStrategy to, LoggingStrategy cc, LoggingStrategy bcc, LoggingStrategy subject, LoggingStrategy body, LoggingStrategy attachments, LoggingStrategy encoding, LoggingStrategy locale, LoggingStrategy sentAt, LoggingStrategy receiptTo, LoggingStrategy depositionNotificationTo, Ignore ignore) {
            this.from = from;
            this.replyTo = replyTo;
            this.to = to;
            this.cc = cc;
            this.bcc = bcc;
            this.subject = subject;
            this.body = body;
            this.attachments = attachments;
            this.encoding = encoding;
            this.locale = locale;
            this.sentAt = sentAt;
            this.receiptTo = receiptTo;
            this.depositionNotificationTo = depositionNotificationTo;
            this.ignore = ignore;
        }

        public static class Ignore {
            private boolean customHeaders = true;
            private boolean nullAndEmptyCollections = true;

            public boolean isCustomHeaders() {
                return this.customHeaders;
            }

            public boolean isNullAndEmptyCollections() {
                return this.nullAndEmptyCollections;
            }

            public void setCustomHeaders(boolean customHeaders) {
                this.customHeaders = customHeaders;
            }

            public void setNullAndEmptyCollections(boolean nullAndEmptyCollections) {
                this.nullAndEmptyCollections = nullAndEmptyCollections;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ignore)) {
                    return false;
                }
                Ignore other = (Ignore)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isCustomHeaders() != other.isCustomHeaders()) {
                    return false;
                }
                return this.isNullAndEmptyCollections() == other.isNullAndEmptyCollections();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Ignore;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isCustomHeaders() ? 79 : 97);
                result = result * 59 + (this.isNullAndEmptyCollections() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "LoggingProperties.Strategy.Ignore(customHeaders=" + this.isCustomHeaders() + ", nullAndEmptyCollections=" + this.isNullAndEmptyCollections() + ")";
            }
        }
    }
}

