/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.logging.defaultimpl;

import it.ozimov.springboot.mail.logging.EmailRenderer;
import it.ozimov.springboot.mail.logging.defaultimpl.EmailFieldFormat;
import it.ozimov.springboot.mail.model.Email;
import it.ozimov.springboot.mail.model.EmailAttachment;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.mail.internet.InternetAddress;
import lombok.NonNull;

public class CustomizableEmailRenderer
implements EmailRenderer {
    private static final Collector<CharSequence, ?, String> LIST_JOINER = Collectors.joining(", ", "[", "]");
    private Function<InternetAddress, String> fromFormat;
    private Function<InternetAddress, String> replyToFormat;
    private Function<InternetAddress, String> toFormat;
    private Function<InternetAddress, String> ccFormat;
    private Function<InternetAddress, String> bccFormat;
    private UnaryOperator<String> subjectFormat;
    private UnaryOperator<String> bodyFormat;
    private UnaryOperator<String> attachmentsFormat;
    private UnaryOperator<String> encodingFormat;
    private Function<Locale, String> localeFormat;
    private Function<Date, String> sentAtFormat;
    private Function<InternetAddress, String> receiptToFormat;
    private Function<InternetAddress, String> depositionNotificationToFormat;
    private boolean customHeadersIncluded;
    private boolean includeNullAndEmptyCollections;

    public static CustomizableEmailRendererBuilder builder() {
        return new CustomizableEmailRendererBuilder();
    }

    @Override
    public String render(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        StringBuilder emailStringBuilder = new StringBuilder("Email{");
        boolean isFirst = true;
        if (Objects.nonNull(this.fromFormat) && !this.skipField(email.getFrom())) {
            isFirst = false;
            emailStringBuilder.append("from=").append(this.fromFormat.apply(email.getFrom()));
        }
        if (Objects.nonNull(this.replyToFormat) && !this.skipField(email.getReplyTo())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("replyTo=").append(this.replyToFormat.apply(email.getReplyTo()));
        }
        if (Objects.nonNull(this.toFormat) && !this.skipField(email.getTo())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("to=");
            if (Objects.isNull(email.getTo())) {
                emailStringBuilder.append(EmailFieldFormat.nullValue());
            } else {
                emailStringBuilder.append(this.joinAddresses(email.getTo(), this.toFormat));
            }
        }
        if (Objects.nonNull(this.ccFormat) && !this.skipField(email.getCc())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("cc=");
            if (Objects.isNull(email.getCc())) {
                emailStringBuilder.append(EmailFieldFormat.nullValue());
            } else {
                emailStringBuilder.append(this.joinAddresses(email.getCc(), this.ccFormat));
            }
        }
        if (Objects.nonNull(this.bccFormat) && !this.skipField(email.getBcc())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("bcc=");
            if (Objects.isNull(email.getBcc())) {
                emailStringBuilder.append(EmailFieldFormat.nullValue());
            } else {
                emailStringBuilder.append(this.joinAddresses(email.getBcc(), this.bccFormat));
            }
        }
        if (Objects.nonNull(this.subjectFormat) && !this.skipField(email.getSubject())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("subject=").append((String)this.subjectFormat.apply(email.getSubject()));
        }
        if (Objects.nonNull(this.bodyFormat) && !this.skipField(email.getBody())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("body=").append((String)this.bodyFormat.apply(email.getBody()));
        }
        if (Objects.nonNull(this.attachmentsFormat) && !this.skipField(email.getAttachments())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("attachments=").append(email.getAttachments().stream().map(EmailAttachment::getAttachmentName).map(this.attachmentsFormat).collect(LIST_JOINER));
        }
        if (Objects.nonNull(this.encodingFormat) && !this.skipField(email.getEncoding())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("encoding=").append((String)this.encodingFormat.apply(email.getEncoding()));
        }
        if (Objects.nonNull(this.localeFormat) && !this.skipField(email.getLocale())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("locale=").append(this.localeFormat.apply(email.getLocale()));
        }
        if (Objects.nonNull(this.sentAtFormat) && !this.skipField(email.getSentAt())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("sentAt=").append(this.sentAtFormat.apply(email.getSentAt()));
        }
        if (Objects.nonNull(this.receiptToFormat) && !this.skipField(email.getReceiptTo())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("receiptTo=").append(this.receiptToFormat.apply(email.getReceiptTo()));
        }
        if (Objects.nonNull(this.depositionNotificationToFormat) && !this.skipField(email.getDepositionNotificationTo())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            isFirst = false;
            emailStringBuilder.append("depositionNotificationTo=").append(this.depositionNotificationToFormat.apply(email.getDepositionNotificationTo()));
        }
        if (this.customHeadersIncluded && !this.skipField(email.getCustomHeaders())) {
            if (!isFirst) {
                emailStringBuilder.append(", ");
            }
            emailStringBuilder.append("customHeaders=");
            if (Objects.isNull(email.getCustomHeaders())) {
                emailStringBuilder.append(EmailFieldFormat.nullValue());
            } else {
                emailStringBuilder.append(email.getCustomHeaders().entrySet().stream().map(entry -> (String)entry.getKey() + '=' + (String)entry.getValue()).collect(LIST_JOINER));
            }
        }
        emailStringBuilder.append('}');
        return emailStringBuilder.toString();
    }

    private boolean skipField(Object object) {
        return !this.includeNullAndEmptyCollections && (Objects.isNull(object) || object instanceof Collection && ((Collection)object).isEmpty() || object instanceof Map && ((Map)object).isEmpty());
    }

    private String joinAddresses(Collection<InternetAddress> internetAddressCollection, Function<InternetAddress, String> internetAddressStringFormatter) {
        return internetAddressCollection.stream().map(internetAddressStringFormatter).collect(LIST_JOINER);
    }

    public static class CustomizableEmailRendererBuilder {
        private CustomizableEmailRenderer customizableEmailRenderer = new CustomizableEmailRenderer();

        private CustomizableEmailRendererBuilder() {
        }

        public CustomizableEmailRendererBuilder withFromFormat(@NonNull Function<InternetAddress, String> fromFormat) {
            if (fromFormat == null) {
                throw new NullPointerException("fromFormat");
            }
            this.customizableEmailRenderer.fromFormat = fromFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withReplyToFormat(@NonNull Function<InternetAddress, String> replyToFormat) {
            if (replyToFormat == null) {
                throw new NullPointerException("replyToFormat");
            }
            this.customizableEmailRenderer.replyToFormat = replyToFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withToFormat(@NonNull Function<InternetAddress, String> toFormat) {
            if (toFormat == null) {
                throw new NullPointerException("toFormat");
            }
            this.customizableEmailRenderer.toFormat = toFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withCcFormat(@NonNull Function<InternetAddress, String> ccFormat) {
            if (ccFormat == null) {
                throw new NullPointerException("ccFormat");
            }
            this.customizableEmailRenderer.ccFormat = ccFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withBccFormat(@NonNull Function<InternetAddress, String> bccFormat) {
            if (bccFormat == null) {
                throw new NullPointerException("bccFormat");
            }
            this.customizableEmailRenderer.bccFormat = bccFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withSubjectFormat(@NonNull UnaryOperator<String> subjectFormat) {
            if (subjectFormat == null) {
                throw new NullPointerException("subjectFormat");
            }
            this.customizableEmailRenderer.subjectFormat = subjectFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withBodyFormat(@NonNull UnaryOperator<String> bodyFormat) {
            if (bodyFormat == null) {
                throw new NullPointerException("bodyFormat");
            }
            this.customizableEmailRenderer.bodyFormat = bodyFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withAttachmentsFormat(@NonNull UnaryOperator<String> attachmentsFormat) {
            if (attachmentsFormat == null) {
                throw new NullPointerException("attachmentsFormat");
            }
            this.customizableEmailRenderer.attachmentsFormat = attachmentsFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withEncodingFormat(@NonNull UnaryOperator<String> encodingFormat) {
            if (encodingFormat == null) {
                throw new NullPointerException("encodingFormat");
            }
            this.customizableEmailRenderer.encodingFormat = encodingFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withLocaleFormat(@NonNull Function<Locale, String> localeFormat) {
            if (localeFormat == null) {
                throw new NullPointerException("localeFormat");
            }
            this.customizableEmailRenderer.localeFormat = localeFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withSentAtFormat(@NonNull Function<Date, String> sentAtFormat) {
            if (sentAtFormat == null) {
                throw new NullPointerException("sentAtFormat");
            }
            this.customizableEmailRenderer.sentAtFormat = sentAtFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withReceiptToFormat(@NonNull Function<InternetAddress, String> receiptToFormat) {
            if (receiptToFormat == null) {
                throw new NullPointerException("receiptToFormat");
            }
            this.customizableEmailRenderer.receiptToFormat = receiptToFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder withDepositionNotificationToFormat(@NonNull Function<InternetAddress, String> depositionNotificationToFormat) {
            if (depositionNotificationToFormat == null) {
                throw new NullPointerException("depositionNotificationToFormat");
            }
            this.customizableEmailRenderer.depositionNotificationToFormat = depositionNotificationToFormat;
            return this;
        }

        public CustomizableEmailRendererBuilder includeCustomHeaders() {
            this.customizableEmailRenderer.customHeadersIncluded = true;
            return this;
        }

        public CustomizableEmailRendererBuilder includeNullAndEmptyCollections() {
            this.customizableEmailRenderer.includeNullAndEmptyCollections = true;
            return this;
        }

        public CustomizableEmailRenderer build() {
            return this.customizableEmailRenderer;
        }
    }
}

