/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.logging.defaultimpl;

import com.google.common.base.Preconditions;
import it.ozimov.springboot.mail.logging.LoggingStrategy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.mail.internet.InternetAddress;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailFieldFormat {
    private static final Logger log = LoggerFactory.getLogger(EmailFieldFormat.class);
    private static final String STARS = "***";
    private static final String NULL = "NULL";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = EmailFieldFormat.createSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat DATE_FORMAT_WITH_ZONE_ID = EmailFieldFormat.createSimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    public static UnaryOperator<String> textFormatterFrom(@NonNull LoggingStrategy loggingStrategy) {
        if (loggingStrategy == null) {
            throw new NullPointerException("loggingStrategy");
        }
        switch (loggingStrategy) {
            case PLAIN_TEXT: {
                return EmailFieldFormat::plainText;
            }
            case HIDDEN: {
                break;
            }
            case FIRST_DOZEN_THEN_STARS: {
                return EmailFieldFormat::firstDozenThenStars;
            }
            default: {
                EmailFieldFormat.logUnsupportedLoggingStrategy(loggingStrategy, "String");
            }
        }
        return null;
    }

    public static Function<InternetAddress, String> emailFormatterFrom(@NonNull LoggingStrategy loggingStrategy) {
        if (loggingStrategy == null) {
            throw new NullPointerException("loggingStrategy");
        }
        switch (loggingStrategy) {
            case PLAIN_TEXT: {
                return EmailFieldFormat::plainText;
            }
            case HIDDEN: {
                break;
            }
            case FIRST_DOZEN_THEN_STARS: {
                return EmailFieldFormat::firstDozenThenStars;
            }
            case FULL_TEXT_FROM_COMMERCIAL_AT: {
                return EmailFieldFormat::textFromAt;
            }
            case FULL_TEXT_UP_TO_COMMERCIAL_AT: {
                return EmailFieldFormat::textUpToAt;
            }
            default: {
                EmailFieldFormat.logUnsupportedLoggingStrategy(loggingStrategy, "InternetAddress");
            }
        }
        return null;
    }

    public static Function<Locale, String> localeFormatterFrom(@NonNull LoggingStrategy loggingStrategy) {
        if (loggingStrategy == null) {
            throw new NullPointerException("loggingStrategy");
        }
        switch (loggingStrategy) {
            case PLAIN_TEXT: {
                return EmailFieldFormat::plainText;
            }
            case HIDDEN: {
                break;
            }
            default: {
                EmailFieldFormat.logUnsupportedLoggingStrategy(loggingStrategy, "Locale");
            }
        }
        return null;
    }

    public static Function<Date, String> dateFormatterFrom(@NonNull LoggingStrategy loggingStrategy) {
        if (loggingStrategy == null) {
            throw new NullPointerException("loggingStrategy");
        }
        switch (loggingStrategy) {
            case PLAIN_TEXT: {
                break;
            }
            case HIDDEN: {
                break;
            }
            case STANDARD_DATE_FORMAT: {
                return EmailFieldFormat::dateFormat;
            }
            case STANDARD_DATE_FORMAT_WITH_ZONE_ID: {
                return EmailFieldFormat::dateFormatWithZoneId;
            }
            default: {
                EmailFieldFormat.logUnsupportedLoggingStrategy(loggingStrategy, "Date");
            }
        }
        return null;
    }

    public static String plainText(Locale locale) {
        return EmailFieldFormat.plainText(Objects.isNull(locale) ? null : locale.toString());
    }

    public static String plainText(InternetAddress internetAddress) {
        return EmailFieldFormat.plainText(Objects.isNull(internetAddress) ? null : internetAddress.getAddress());
    }

    public static String plainText(String text) {
        if (Objects.isNull(text)) {
            return NULL;
        }
        return text;
    }

    public static String firstDozenThenStars(InternetAddress internetAddress) {
        return EmailFieldFormat.firstDozenThenStars(Objects.isNull(internetAddress) ? null : internetAddress.getAddress());
    }

    public static String firstDozenThenStars(String text) {
        if (Objects.isNull(text)) {
            return NULL;
        }
        return text.length() > 12 ? EmailFieldFormat.appendStars(text, 0, 12) : text;
    }

    public static String textFromAt(InternetAddress internetAddress) {
        return EmailFieldFormat.textFromAt(Objects.isNull(internetAddress) ? null : internetAddress.getAddress());
    }

    public static String textFromAt(String text) {
        if (Objects.isNull(text)) {
            return NULL;
        }
        int indexOfAt = text.indexOf(64);
        Preconditions.checkArgument((indexOfAt > 0 ? 1 : 0) != 0, (String)"Given text should contain '@', while %s given.", (Object)text);
        return EmailFieldFormat.prependStars(text, indexOfAt, text.length());
    }

    public static String textUpToAt(InternetAddress internetAddress) {
        return EmailFieldFormat.textUpToAt(Objects.isNull(internetAddress) ? null : internetAddress.getAddress());
    }

    public static String textUpToAt(String text) {
        if (Objects.isNull(text)) {
            return NULL;
        }
        int indexOfAt = text.indexOf(64);
        Preconditions.checkArgument((indexOfAt > 0 ? 1 : 0) != 0, (String)"Given text should contain '@', while %s given.", (Object)text);
        return EmailFieldFormat.appendStars(text, 0, indexOfAt + 1);
    }

    public static String dateFormat(Date date) {
        if (Objects.isNull(date)) {
            return NULL;
        }
        return SIMPLE_DATE_FORMAT.format(date);
    }

    public static String dateFormatWithZoneId(Date date) {
        if (Objects.isNull(date)) {
            return NULL;
        }
        return DATE_FORMAT_WITH_ZONE_ID.format(date);
    }

    public static String nullValue() {
        return NULL;
    }

    private static String appendStars(String text, int from, int to) {
        return text.substring(from, to) + STARS;
    }

    private static String prependStars(String text, int from, int to) {
        return STARS + text.substring(from, to);
    }

    private static SimpleDateFormat createSimpleDateFormat(String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    private static void logUnsupportedLoggingStrategy(LoggingStrategy loggingStrategy, String inputType) {
        log.warn("LoggingStrategy {} is not supported for the input type {}.", (Object)loggingStrategy, (Object)inputType);
    }

    private EmailFieldFormat() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

