/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.logging.defaultimpl;

import it.ozimov.springboot.mail.logging.EmailLogRenderer;
import it.ozimov.springboot.mail.logging.EmailRenderer;
import it.ozimov.springboot.mail.model.Email;
import lombok.NonNull;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SanitizedEmailLogRenderer
implements EmailLogRenderer {
    private static final Logger log = LoggerFactory.getLogger(SanitizedEmailLogRenderer.class);
    private final EmailRenderer emailRenderer;
    protected Logger logger = log;

    @Autowired
    public SanitizedEmailLogRenderer(EmailRenderer emailRenderer) {
        this.emailRenderer = emailRenderer;
    }

    private static String sanitizeString(String text) {
        return Encode.forJava((String)text);
    }

    @Override
    public EmailLogRenderer registerLogger(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        this.logger = logger;
        return this;
    }

    @Override
    public void trace(@NonNull String message, @NonNull Email email, Object ... messageParams) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message, (Object)this.renderEmail(email), (Object)messageParams);
        }
    }

    @Override
    public void trace(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.renderEmail(email));
        }
    }

    @Override
    public void debug(@NonNull String message, @NonNull Email email, Object ... messageParams) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, (Object)this.renderEmail(email), (Object)messageParams);
        }
    }

    @Override
    public void debug(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.renderEmail(email));
        }
    }

    @Override
    public void info(@NonNull String message, @NonNull Email email, Object ... messageParams) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message, (Object)this.renderEmail(email), (Object)messageParams);
        }
    }

    @Override
    public void info(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.renderEmail(email));
        }
    }

    @Override
    public void warn(@NonNull String message, @NonNull Email email, Object ... messageParams) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, (Object)this.renderEmail(email), (Object)messageParams);
        }
    }

    @Override
    public void warn(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.renderEmail(email));
        }
    }

    @Override
    public void error(@NonNull String message, @NonNull Email email, Object ... messageParams) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, (Object)this.renderEmail(email), (Object)messageParams);
        }
    }

    @Override
    public void error(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.renderEmail(email));
        }
    }

    private String renderEmail(Email email) {
        return SanitizedEmailLogRenderer.sanitizeString(this.emailRenderer.render(email));
    }
}

