/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.model;

import it.ozimov.springboot.mail.model.Email;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Comparator;

public interface EmailSchedulingData
extends Comparable<EmailSchedulingData>,
Serializable {
    public static final Comparator<EmailSchedulingData> DEFAULT_COMPARATOR = (o1, o2) -> {
        OffsetDateTime o2ScheduledDateTime;
        OffsetDateTime o1ScheduledDateTime = o1.getScheduledDateTime();
        if (o1ScheduledDateTime.isBefore(o2ScheduledDateTime = o2.getScheduledDateTime())) {
            return -1;
        }
        if (o1ScheduledDateTime.isAfter(o2ScheduledDateTime)) {
            return 1;
        }
        int priorityComparison = Integer.compare(o1.getAssignedPriority(), o2.getAssignedPriority());
        if (priorityComparison != 0) {
            return priorityComparison;
        }
        return o1.getId().compareTo(o2.getId());
    };

    public String getId();

    public Email getEmail();

    default public int getDesiredPriority() {
        return 1;
    }

    default public int getAssignedPriority() {
        return 1;
    }

    public OffsetDateTime getScheduledDateTime();

    @Override
    default public int compareTo(EmailSchedulingData o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }
}

