/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.model.defaultimpl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.ozimov.springboot.mail.model.Email;
import it.ozimov.springboot.mail.model.EmailAttachment;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import lombok.NonNull;

public class DefaultEmail
implements Email {
    private static final long serialVersionUID = 634175529482595823L;
    @NonNull
    private InternetAddress from;
    private InternetAddress replyTo;
    private Collection<InternetAddress> to;
    private Collection<InternetAddress> cc;
    private Collection<InternetAddress> bcc;
    @NonNull
    private String subject;
    @NonNull
    private String body;
    @NonNull
    private Collection<EmailAttachment> attachments;
    private String encoding = StandardCharsets.UTF_8.name();
    private Locale locale;
    private Date sentAt;
    private InternetAddress receiptTo;
    private InternetAddress depositionNotificationTo;
    private Map<String, String> customHeaders;

    public static DefaultEmailBuilder builder() {
        return new DefaultEmailBuilder();
    }

    public DefaultEmail() {
    }

    @ConstructorProperties(value={"from", "subject", "body", "attachments"})
    public DefaultEmail(@NonNull InternetAddress from, @NonNull String subject, @NonNull String body, @NonNull Collection<EmailAttachment> attachments) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        if (body == null) {
            throw new NullPointerException("body");
        }
        if (attachments == null) {
            throw new NullPointerException("attachments");
        }
        this.from = from;
        this.subject = subject;
        this.body = body;
        this.attachments = attachments;
    }

    @ConstructorProperties(value={"from", "replyTo", "to", "cc", "bcc", "subject", "body", "attachments", "encoding", "locale", "sentAt", "receiptTo", "depositionNotificationTo", "customHeaders"})
    public DefaultEmail(@NonNull InternetAddress from, InternetAddress replyTo, Collection<InternetAddress> to, Collection<InternetAddress> cc, Collection<InternetAddress> bcc, @NonNull String subject, @NonNull String body, @NonNull Collection<EmailAttachment> attachments, String encoding, Locale locale, Date sentAt, InternetAddress receiptTo, InternetAddress depositionNotificationTo, Map<String, String> customHeaders) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        if (body == null) {
            throw new NullPointerException("body");
        }
        if (attachments == null) {
            throw new NullPointerException("attachments");
        }
        this.from = from;
        this.replyTo = replyTo;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.body = body;
        this.attachments = attachments;
        this.encoding = encoding;
        this.locale = locale;
        this.sentAt = sentAt;
        this.receiptTo = receiptTo;
        this.depositionNotificationTo = depositionNotificationTo;
        this.customHeaders = customHeaders;
    }

    @Override
    @NonNull
    public InternetAddress getFrom() {
        return this.from;
    }

    @Override
    public InternetAddress getReplyTo() {
        return this.replyTo;
    }

    @Override
    public Collection<InternetAddress> getTo() {
        return this.to;
    }

    @Override
    public Collection<InternetAddress> getCc() {
        return this.cc;
    }

    @Override
    public Collection<InternetAddress> getBcc() {
        return this.bcc;
    }

    @Override
    @NonNull
    public String getSubject() {
        return this.subject;
    }

    @Override
    @NonNull
    public String getBody() {
        return this.body;
    }

    @Override
    @NonNull
    public Collection<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Date getSentAt() {
        return this.sentAt;
    }

    @Override
    public InternetAddress getReceiptTo() {
        return this.receiptTo;
    }

    @Override
    public InternetAddress getDepositionNotificationTo() {
        return this.depositionNotificationTo;
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setFrom(@NonNull InternetAddress from) {
        if (from == null) {
            throw new NullPointerException("from");
        }
        this.from = from;
    }

    public void setReplyTo(InternetAddress replyTo) {
        this.replyTo = replyTo;
    }

    public void setTo(Collection<InternetAddress> to) {
        this.to = to;
    }

    public void setCc(Collection<InternetAddress> cc) {
        this.cc = cc;
    }

    public void setBcc(Collection<InternetAddress> bcc) {
        this.bcc = bcc;
    }

    public void setSubject(@NonNull String subject) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        this.subject = subject;
    }

    public void setBody(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body");
        }
        this.body = body;
    }

    public void setAttachments(@NonNull Collection<EmailAttachment> attachments) {
        if (attachments == null) {
            throw new NullPointerException("attachments");
        }
        this.attachments = attachments;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setSentAt(Date sentAt) {
        this.sentAt = sentAt;
    }

    public void setReceiptTo(InternetAddress receiptTo) {
        this.receiptTo = receiptTo;
    }

    public void setDepositionNotificationTo(InternetAddress depositionNotificationTo) {
        this.depositionNotificationTo = depositionNotificationTo;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEmail)) {
            return false;
        }
        DefaultEmail other = (DefaultEmail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InternetAddress this$from = this.getFrom();
        InternetAddress other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        InternetAddress this$replyTo = this.getReplyTo();
        InternetAddress other$replyTo = other.getReplyTo();
        if (this$replyTo == null ? other$replyTo != null : !this$replyTo.equals(other$replyTo)) {
            return false;
        }
        Collection<InternetAddress> this$to = this.getTo();
        Collection<InternetAddress> other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Collection<InternetAddress> this$cc = this.getCc();
        Collection<InternetAddress> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        Collection<InternetAddress> this$bcc = this.getBcc();
        Collection<InternetAddress> other$bcc = other.getBcc();
        if (this$bcc == null ? other$bcc != null : !((Object)this$bcc).equals(other$bcc)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Collection<EmailAttachment> this$attachments = this.getAttachments();
        Collection<EmailAttachment> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        String this$encoding = this.getEncoding();
        String other$encoding = other.getEncoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        Date this$sentAt = this.getSentAt();
        Date other$sentAt = other.getSentAt();
        if (this$sentAt == null ? other$sentAt != null : !((Object)this$sentAt).equals(other$sentAt)) {
            return false;
        }
        InternetAddress this$receiptTo = this.getReceiptTo();
        InternetAddress other$receiptTo = other.getReceiptTo();
        if (this$receiptTo == null ? other$receiptTo != null : !this$receiptTo.equals(other$receiptTo)) {
            return false;
        }
        InternetAddress this$depositionNotificationTo = this.getDepositionNotificationTo();
        InternetAddress other$depositionNotificationTo = other.getDepositionNotificationTo();
        if (this$depositionNotificationTo == null ? other$depositionNotificationTo != null : !this$depositionNotificationTo.equals(other$depositionNotificationTo)) {
            return false;
        }
        Map<String, String> this$customHeaders = this.getCustomHeaders();
        Map<String, String> other$customHeaders = other.getCustomHeaders();
        return !(this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultEmail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InternetAddress $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        InternetAddress $replyTo = this.getReplyTo();
        result = result * 59 + ($replyTo == null ? 43 : $replyTo.hashCode());
        Collection<InternetAddress> $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Collection<InternetAddress> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        Collection<InternetAddress> $bcc = this.getBcc();
        result = result * 59 + ($bcc == null ? 43 : ((Object)$bcc).hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Collection<EmailAttachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        String $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : $encoding.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        Date $sentAt = this.getSentAt();
        result = result * 59 + ($sentAt == null ? 43 : ((Object)$sentAt).hashCode());
        InternetAddress $receiptTo = this.getReceiptTo();
        result = result * 59 + ($receiptTo == null ? 43 : $receiptTo.hashCode());
        InternetAddress $depositionNotificationTo = this.getDepositionNotificationTo();
        result = result * 59 + ($depositionNotificationTo == null ? 43 : $depositionNotificationTo.hashCode());
        Map<String, String> $customHeaders = this.getCustomHeaders();
        result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultEmail(from=" + this.getFrom() + ", replyTo=" + this.getReplyTo() + ", to=" + this.getTo() + ", cc=" + this.getCc() + ", bcc=" + this.getBcc() + ", subject=" + this.getSubject() + ", body=" + this.getBody() + ", attachments=" + this.getAttachments() + ", encoding=" + this.getEncoding() + ", locale=" + this.getLocale() + ", sentAt=" + this.getSentAt() + ", receiptTo=" + this.getReceiptTo() + ", depositionNotificationTo=" + this.getDepositionNotificationTo() + ", customHeaders=" + this.getCustomHeaders() + ")";
    }

    public static class DefaultEmailBuilder {
        private InternetAddress from;
        private InternetAddress replyTo;
        private Collection<InternetAddress> to;
        private String subject;
        private String body;
        private ArrayList<EmailAttachment> attachments;
        private Locale locale;
        private Date sentAt;
        private InternetAddress receiptTo;
        private InternetAddress depositionNotificationTo;
        private Collection<InternetAddress> cc = ImmutableList.of();
        private Collection<InternetAddress> bcc = ImmutableList.of();
        private String encoding = StandardCharsets.UTF_8.name();
        private Map<String, String> customHeaders = ImmutableMap.of();

        DefaultEmailBuilder() {
        }

        public DefaultEmailBuilder from(InternetAddress from) {
            this.from = from;
            return this;
        }

        public DefaultEmailBuilder replyTo(InternetAddress replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public DefaultEmailBuilder to(Collection<InternetAddress> to) {
            this.to = to;
            return this;
        }

        public DefaultEmailBuilder cc(Collection<InternetAddress> cc) {
            this.cc = cc;
            return this;
        }

        public DefaultEmailBuilder bcc(Collection<InternetAddress> bcc) {
            this.bcc = bcc;
            return this;
        }

        public DefaultEmailBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public DefaultEmailBuilder body(String body) {
            this.body = body;
            return this;
        }

        public DefaultEmailBuilder attachment(EmailAttachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public DefaultEmailBuilder attachments(Collection<? extends EmailAttachment> attachments) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public DefaultEmailBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public DefaultEmailBuilder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public DefaultEmailBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public DefaultEmailBuilder sentAt(Date sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        public DefaultEmailBuilder receiptTo(InternetAddress receiptTo) {
            this.receiptTo = receiptTo;
            return this;
        }

        public DefaultEmailBuilder depositionNotificationTo(InternetAddress depositionNotificationTo) {
            this.depositionNotificationTo = depositionNotificationTo;
            return this;
        }

        public DefaultEmailBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public DefaultEmail build() {
            List<EmailAttachment> attachments;
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<EmailAttachment>(this.attachments));
                }
            }
            return new DefaultEmail(this.from, this.replyTo, this.to, this.cc, this.bcc, this.subject, this.body, attachments, this.encoding, this.locale, this.sentAt, this.receiptTo, this.depositionNotificationTo, this.customHeaders);
        }

        public String toString() {
            return "DefaultEmail.DefaultEmailBuilder(from=" + this.from + ", replyTo=" + this.replyTo + ", to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", subject=" + this.subject + ", body=" + this.body + ", attachments=" + this.attachments + ", encoding=" + this.encoding + ", locale=" + this.locale + ", sentAt=" + this.sentAt + ", receiptTo=" + this.receiptTo + ", depositionNotificationTo=" + this.depositionNotificationTo + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

