/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.model.defaultimpl;

import it.ozimov.springboot.mail.model.EmailAttachment;
import it.ozimov.springboot.mail.utils.TikaDetector;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class DefaultEmailAttachment
implements EmailAttachment {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailAttachment.class);
    private static final long serialVersionUID = -3307831714212032363L;
    @NonNull
    private String attachmentName;
    @NonNull
    private byte[] attachmentData;
    private MediaType mediaType;

    @Override
    public MediaType getContentType() throws IOException {
        MediaType mediaType;
        ByteArrayInputStream attachmentDataStream = new ByteArrayInputStream(this.attachmentData);
        try {
            mediaType = Optional.ofNullable(this.mediaType).orElse(TikaDetector.tikaDetector().detect(attachmentDataStream, this.attachmentName));
        }
        catch (IOException e) {
            log.error("The MimeType is not set. Tried to guess it but something went wrong.", (Throwable)e);
            throw e;
        }
        return mediaType;
    }

    public static DefaultEmailAttachmentBuilder builder() {
        return new DefaultEmailAttachmentBuilder();
    }

    public DefaultEmailAttachment() {
    }

    @ConstructorProperties(value={"attachmentName", "attachmentData"})
    public DefaultEmailAttachment(@NonNull String attachmentName, @NonNull byte[] attachmentData) {
        if (attachmentName == null) {
            throw new NullPointerException("attachmentName");
        }
        if (attachmentData == null) {
            throw new NullPointerException("attachmentData");
        }
        this.attachmentName = attachmentName;
        this.attachmentData = attachmentData;
    }

    @ConstructorProperties(value={"attachmentName", "attachmentData", "mediaType"})
    public DefaultEmailAttachment(@NonNull String attachmentName, @NonNull byte[] attachmentData, MediaType mediaType) {
        if (attachmentName == null) {
            throw new NullPointerException("attachmentName");
        }
        if (attachmentData == null) {
            throw new NullPointerException("attachmentData");
        }
        this.attachmentName = attachmentName;
        this.attachmentData = attachmentData;
        this.mediaType = mediaType;
    }

    public String toString() {
        return "DefaultEmailAttachment(attachmentName=" + this.getAttachmentName() + ", mediaType=" + this.mediaType + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEmailAttachment)) {
            return false;
        }
        DefaultEmailAttachment other = (DefaultEmailAttachment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$attachmentName = this.getAttachmentName();
        String other$attachmentName = other.getAttachmentName();
        if (this$attachmentName == null ? other$attachmentName != null : !this$attachmentName.equals(other$attachmentName)) {
            return false;
        }
        if (!Arrays.equals(this.getAttachmentData(), other.getAttachmentData())) {
            return false;
        }
        MediaType this$mediaType = this.mediaType;
        MediaType other$mediaType = other.mediaType;
        return !(this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultEmailAttachment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $attachmentName = this.getAttachmentName();
        result = result * 59 + ($attachmentName == null ? 43 : $attachmentName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAttachmentData());
        MediaType $mediaType = this.mediaType;
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        return result;
    }

    @Override
    @NonNull
    public String getAttachmentName() {
        return this.attachmentName;
    }

    @Override
    @NonNull
    public byte[] getAttachmentData() {
        return this.attachmentData;
    }

    public static class DefaultEmailAttachmentBuilder {
        private String attachmentName;
        private byte[] attachmentData;
        private MediaType mediaType;

        DefaultEmailAttachmentBuilder() {
        }

        public DefaultEmailAttachmentBuilder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public DefaultEmailAttachmentBuilder attachmentData(byte[] attachmentData) {
            this.attachmentData = attachmentData;
            return this;
        }

        public DefaultEmailAttachmentBuilder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public DefaultEmailAttachment build() {
            return new DefaultEmailAttachment(this.attachmentName, this.attachmentData, this.mediaType);
        }

        public String toString() {
            return "DefaultEmailAttachment.DefaultEmailAttachmentBuilder(attachmentName=" + this.attachmentName + ", attachmentData=" + Arrays.toString(this.attachmentData) + ", mediaType=" + this.mediaType + ")";
        }
    }
}

