/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.model.defaultimpl;

import com.google.common.base.Preconditions;
import it.ozimov.springboot.mail.model.Email;
import it.ozimov.springboot.mail.model.EmailSchedulingData;
import it.ozimov.springboot.mail.utils.TimeUtils;
import java.time.OffsetDateTime;
import java.util.UUID;
import lombok.NonNull;

public class DefaultEmailSchedulingData
implements EmailSchedulingData {
    private static final long serialVersionUID = 60021395842232155L;
    private final String id = UUID.randomUUID().toString();
    protected final Email email;
    protected final OffsetDateTime scheduledDateTime;
    protected final int assignedPriority;
    protected final int desiredPriority;

    public DefaultEmailSchedulingData(@NonNull Email email, @NonNull OffsetDateTime scheduledDateTime, int desiredPriority, int assignedPriority) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (scheduledDateTime == null) {
            throw new NullPointerException("scheduledDateTime");
        }
        Preconditions.checkArgument((assignedPriority > 0 ? 1 : 0) != 0, (Object)"Priority cannot be less than 1");
        this.email = email;
        this.scheduledDateTime = scheduledDateTime;
        this.desiredPriority = desiredPriority;
        this.assignedPriority = assignedPriority;
    }

    public static DefaultEmailSchedulingDataBuilder defaultEmailSchedulingDataBuilder() {
        return new DefaultEmailSchedulingDataBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Email getEmail() {
        return this.email;
    }

    @Override
    public OffsetDateTime getScheduledDateTime() {
        return this.scheduledDateTime;
    }

    @Override
    public int getAssignedPriority() {
        return this.assignedPriority;
    }

    @Override
    public int getDesiredPriority() {
        return this.desiredPriority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEmailSchedulingData)) {
            return false;
        }
        DefaultEmailSchedulingData other = (DefaultEmailSchedulingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        OffsetDateTime this$scheduledDateTime = this.getScheduledDateTime();
        OffsetDateTime other$scheduledDateTime = other.getScheduledDateTime();
        if (this$scheduledDateTime == null ? other$scheduledDateTime != null : !((Object)this$scheduledDateTime).equals(other$scheduledDateTime)) {
            return false;
        }
        if (this.getAssignedPriority() != other.getAssignedPriority()) {
            return false;
        }
        return this.getDesiredPriority() == other.getDesiredPriority();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultEmailSchedulingData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        OffsetDateTime $scheduledDateTime = this.getScheduledDateTime();
        result = result * 59 + ($scheduledDateTime == null ? 43 : ((Object)$scheduledDateTime).hashCode());
        result = result * 59 + this.getAssignedPriority();
        result = result * 59 + this.getDesiredPriority();
        return result;
    }

    public String toString() {
        return "DefaultEmailSchedulingData(id=" + this.getId() + ", scheduledDateTime=" + this.getScheduledDateTime() + ", assignedPriority=" + this.getAssignedPriority() + ")";
    }

    public static class DefaultEmailSchedulingDataBuilder {
        private Email email;
        private int desiredPriority;
        private int assignedPriority;
        protected OffsetDateTime scheduledDateTime = TimeUtils.offsetDateTimeNow();

        DefaultEmailSchedulingDataBuilder() {
        }

        public DefaultEmailSchedulingDataBuilder email(Email email) {
            this.email = email;
            return this;
        }

        public DefaultEmailSchedulingDataBuilder scheduledDateTime(OffsetDateTime scheduledDateTime) {
            this.scheduledDateTime = scheduledDateTime;
            return this;
        }

        public DefaultEmailSchedulingDataBuilder desiredPriority(int desiredPriority) {
            this.desiredPriority = desiredPriority;
            return this;
        }

        public DefaultEmailSchedulingDataBuilder assignedPriority(int assignedPriority) {
            this.assignedPriority = assignedPriority;
            return this;
        }

        public DefaultEmailSchedulingData build() {
            return new DefaultEmailSchedulingData(this.email, this.scheduledDateTime, this.desiredPriority, this.assignedPriority);
        }

        public String toString() {
            return "DefaultEmailSchedulingData.DefaultEmailSchedulingDataBuilder(email=" + this.email + ", scheduledDateTime=" + this.scheduledDateTime + ", desiredPriority=" + this.desiredPriority + ", assignedPriority=" + this.assignedPriority + ")";
        }
    }
}

