/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.model.defaultimpl;

import it.ozimov.springboot.mail.model.Email;
import it.ozimov.springboot.mail.model.InlinePicture;
import it.ozimov.springboot.mail.model.defaultimpl.DefaultEmailSchedulingData;
import it.ozimov.springboot.mail.utils.TimeUtils;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Map;
import lombok.NonNull;

public class TemplateEmailSchedulingData
extends DefaultEmailSchedulingData {
    private static final long serialVersionUID = -8267649519235191875L;
    private final String template;
    private final Map<String, Object> modelObject;
    private final InlinePicture[] inlinePictures;

    public TemplateEmailSchedulingData(@NonNull Email email, @NonNull OffsetDateTime scheduledDateTime, int desiredPriority, int assignedPriority, @NonNull String template, @NonNull Map<String, Object> modelObject, @NonNull InlinePicture[] inlinePictures) {
        super(email, scheduledDateTime, desiredPriority, assignedPriority);
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (scheduledDateTime == null) {
            throw new NullPointerException("scheduledDateTime");
        }
        if (template == null) {
            throw new NullPointerException("template");
        }
        if (modelObject == null) {
            throw new NullPointerException("modelObject");
        }
        if (inlinePictures == null) {
            throw new NullPointerException("inlinePictures");
        }
        this.template = template;
        this.modelObject = modelObject;
        this.inlinePictures = inlinePictures;
    }

    public static TemplateEmailSchedulingDataBuilder templateEmailSchedulingDataBuilder() {
        return new TemplateEmailSchedulingDataBuilder();
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, Object> getModelObject() {
        return this.modelObject;
    }

    public InlinePicture[] getInlinePictures() {
        return this.inlinePictures;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateEmailSchedulingData)) {
            return false;
        }
        TemplateEmailSchedulingData other = (TemplateEmailSchedulingData)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TemplateEmailSchedulingData;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }

    public static class TemplateEmailSchedulingDataBuilder {
        private Email email;
        private int desiredPriority;
        private int assignedPriority;
        private String template;
        private Map<String, Object> modelObject;
        private InlinePicture[] inlinePictures;
        protected OffsetDateTime scheduledDateTime = TimeUtils.offsetDateTimeNow();

        TemplateEmailSchedulingDataBuilder() {
        }

        public TemplateEmailSchedulingDataBuilder email(Email email) {
            this.email = email;
            return this;
        }

        public TemplateEmailSchedulingDataBuilder scheduledDateTime(OffsetDateTime scheduledDateTime) {
            this.scheduledDateTime = scheduledDateTime;
            return this;
        }

        public TemplateEmailSchedulingDataBuilder desiredPriority(int desiredPriority) {
            this.desiredPriority = desiredPriority;
            return this;
        }

        public TemplateEmailSchedulingDataBuilder assignedPriority(int assignedPriority) {
            this.assignedPriority = assignedPriority;
            return this;
        }

        public TemplateEmailSchedulingDataBuilder template(String template) {
            this.template = template;
            return this;
        }

        public TemplateEmailSchedulingDataBuilder modelObject(Map<String, Object> modelObject) {
            this.modelObject = modelObject;
            return this;
        }

        public TemplateEmailSchedulingDataBuilder inlinePictures(InlinePicture[] inlinePictures) {
            this.inlinePictures = inlinePictures;
            return this;
        }

        public TemplateEmailSchedulingData build() {
            return new TemplateEmailSchedulingData(this.email, this.scheduledDateTime, this.desiredPriority, this.assignedPriority, this.template, this.modelObject, this.inlinePictures);
        }

        public String toString() {
            return "TemplateEmailSchedulingData.TemplateEmailSchedulingDataBuilder(email=" + this.email + ", scheduledDateTime=" + this.scheduledDateTime + ", desiredPriority=" + this.desiredPriority + ", assignedPriority=" + this.assignedPriority + ", template=" + this.template + ", modelObject=" + this.modelObject + ", inlinePictures=" + Arrays.deepToString(this.inlinePictures) + ")";
        }
    }
}

