/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.service.defaultimpl;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import it.ozimov.springboot.mail.logging.EmailLogRenderer;
import it.ozimov.springboot.mail.model.Email;
import it.ozimov.springboot.mail.model.EmailAttachment;
import it.ozimov.springboot.mail.model.InlinePicture;
import it.ozimov.springboot.mail.service.EmailService;
import it.ozimov.springboot.mail.service.TemplateService;
import it.ozimov.springboot.mail.service.exception.CannotSendEmailException;
import it.ozimov.springboot.mail.service.exception.TemplateException;
import it.ozimov.springboot.mail.utils.EmailToMimeMessage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class DefaultEmailService
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailService.class);
    private JavaMailSender javaMailSender;
    private TemplateService templateService;
    private EmailToMimeMessage emailToMimeMessage;
    private EmailLogRenderer emailLogRenderer;

    @Autowired(required=false)
    public DefaultEmailService(@NonNull JavaMailSender javaMailSender, TemplateService templateService, @NonNull EmailToMimeMessage emailToMimeMessage, @NonNull EmailLogRenderer emailLogRenderer) {
        if (javaMailSender == null) {
            throw new NullPointerException("javaMailSender");
        }
        if (emailToMimeMessage == null) {
            throw new NullPointerException("emailToMimeMessage");
        }
        if (emailLogRenderer == null) {
            throw new NullPointerException("emailLogRenderer");
        }
        this.javaMailSender = javaMailSender;
        this.templateService = templateService;
        this.emailToMimeMessage = emailToMimeMessage;
        this.emailLogRenderer = emailLogRenderer.registerLogger(log);
    }

    @Autowired(required=false)
    public DefaultEmailService(@NonNull JavaMailSender javaMailSender, @NonNull EmailToMimeMessage emailToMimeMessage, @NonNull EmailLogRenderer emailLogRenderer) {
        this(javaMailSender, null, emailToMimeMessage, emailLogRenderer);
        if (javaMailSender == null) {
            throw new NullPointerException("javaMailSender");
        }
        if (emailToMimeMessage == null) {
            throw new NullPointerException("emailToMimeMessage");
        }
        if (emailLogRenderer == null) {
            throw new NullPointerException("emailLogRenderer");
        }
    }

    @Override
    public MimeMessage send(@NonNull Email email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        email.setSentAt(new Date());
        MimeMessage mimeMessage = this.toMimeMessage(email);
        this.javaMailSender.send(mimeMessage);
        this.emailLogRenderer.info("Sent email {}.", email, new Object[0]);
        return mimeMessage;
    }

    @Override
    public MimeMessage send(@NonNull Email email, @NonNull String template, Map<String, Object> modelObject, InlinePicture ... inlinePictures) throws CannotSendEmailException {
        if (email == null) {
            throw new NullPointerException("email");
        }
        if (template == null) {
            throw new NullPointerException("template");
        }
        if (inlinePictures == null) {
            throw new NullPointerException("inlinePictures");
        }
        email.setSentAt(new Date());
        MimeMessage mimeMessage = this.toMimeMessage(email);
        try {
            MimeMultipart content = new MimeMultipart("mixed");
            String text = this.templateService.mergeTemplateIntoString(template, (Map)Optional.fromNullable(modelObject).or((Object)ImmutableMap.of()));
            for (InlinePicture inlinePicture : inlinePictures) {
                String cid = UUID.randomUUID().toString();
                text = text.replace(inlinePicture.getTemplateName(), "cid:" + cid);
                MimeBodyPart imagePart = new MimeBodyPart();
                imagePart.attachFile(inlinePicture.getFile());
                imagePart.setContentID('<' + cid + '>');
                imagePart.setDisposition("inline");
                imagePart.setHeader("Content-Type", inlinePicture.getImageType().getContentType());
                content.addBodyPart((BodyPart)imagePart);
            }
            for (EmailAttachment emailAttachment : email.getAttachments()) {
                MimeBodyPart attachmentPart = new MimeBodyPart();
                ByteArrayDataSource source = new ByteArrayDataSource(emailAttachment.getAttachmentData(), emailAttachment.getContentType().toString());
                attachmentPart.setDataHandler(new DataHandler((DataSource)source));
                attachmentPart.setFileName(MimeUtility.encodeText((String)emailAttachment.getAttachmentName()));
                content.addBodyPart((BodyPart)attachmentPart);
            }
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(text, email.getEncoding(), "html");
            content.addBodyPart((BodyPart)textPart);
            mimeMessage.setContent((Multipart)content);
            mimeMessage.saveChanges();
            this.javaMailSender.send(mimeMessage);
            this.emailLogRenderer.info("Sent email {}.", this.emailWithCompiledBody(email, text), new Object[0]);
        }
        catch (IOException e) {
            log.error("The template file cannot be read", (Throwable)e);
            throw new CannotSendEmailException("Error while sending the email due to problems with the template file.", e);
        }
        catch (TemplateException e) {
            log.error("The template file cannot be processed", (Throwable)e);
            throw new CannotSendEmailException("Error while processing the template file with the given model object.", e);
        }
        catch (MessagingException e) {
            log.error("The mime message cannot be created", (Throwable)e);
            throw new CannotSendEmailException("Error while sending the email due to problems with the mime content.", e);
        }
        return mimeMessage;
    }

    private MimeMessage toMimeMessage(@NotNull Email email) {
        return this.emailToMimeMessage.apply(email);
    }

    private Email emailWithCompiledBody(Email email, String body) {
        return new EmailFromTemplate(email).body(body);
    }

    private static class EmailFromTemplate
    implements Email {
        private final Email email;
        private String body;

        @ConstructorProperties(value={"email"})
        public EmailFromTemplate(Email email) {
            this.email = email;
        }

        public EmailFromTemplate body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public InternetAddress getFrom() {
            return this.email.getFrom();
        }

        @Override
        public InternetAddress getReplyTo() {
            return this.email.getReplyTo();
        }

        @Override
        public Collection<InternetAddress> getTo() {
            return this.email.getTo();
        }

        @Override
        public Collection<InternetAddress> getCc() {
            return this.email.getCc();
        }

        @Override
        public Collection<InternetAddress> getBcc() {
            return this.email.getBcc();
        }

        @Override
        public String getSubject() {
            return this.email.getSubject();
        }

        @Override
        public String getBody() {
            return this.email.getBody();
        }

        @Override
        public Collection<EmailAttachment> getAttachments() {
            return this.email.getAttachments();
        }

        @Override
        public String getEncoding() {
            return this.email.getEncoding();
        }

        @Override
        public Locale getLocale() {
            return this.email.getLocale();
        }

        @Override
        public Date getSentAt() {
            return this.email.getSentAt();
        }

        @Override
        public void setSentAt(Date sentAt) {
            this.email.setSentAt(sentAt);
        }

        @Override
        public InternetAddress getReceiptTo() {
            return this.email.getReceiptTo();
        }

        @Override
        public InternetAddress getDepositionNotificationTo() {
            return this.email.getDepositionNotificationTo();
        }

        @Override
        public Map<String, String> getCustomHeaders() {
            return this.email.getCustomHeaders();
        }
    }
}

