/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.service.defaultimpl;

import com.google.common.base.Preconditions;
import it.ozimov.springboot.mail.model.EmailSchedulingData;
import it.ozimov.springboot.mail.service.PersistenceService;
import it.ozimov.springboot.mail.service.defaultimpl.RedisBasedPersistenceServiceConstants;
import java.math.BigDecimal;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Service;

@Service(value="defaultEmailPersistenceService")
@ConditionalOnExpression(value="'${spring.mail.scheduler.enabled:false}' == 'true' && '${spring.mail.scheduler.persistence.enabled:false}' == 'true'")
public class DefaultPersistenceService
implements PersistenceService {
    private static final String MATCH_ALL = "*";
    private final StringRedisTemplate orderingTemplate;
    private final RedisTemplate<String, EmailSchedulingData> valueTemplate;

    @Autowired
    public DefaultPersistenceService(@Qualifier(value="orderingTemplate") @NonNull StringRedisTemplate orderingTemplate, @Qualifier(value="valueTemplate") @NonNull RedisTemplate<String, EmailSchedulingData> valueTemplate) {
        if (orderingTemplate == null) {
            throw new NullPointerException("orderingTemplate");
        }
        if (valueTemplate == null) {
            throw new NullPointerException("valueTemplate");
        }
        this.orderingTemplate = orderingTemplate;
        this.orderingTemplate.setEnableTransactionSupport(true);
        this.valueTemplate = valueTemplate;
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        this.valueTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        this.valueTemplate.setValueSerializer((RedisSerializer)jdkSerializationRedisSerializer);
        this.valueTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        this.valueTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
        this.valueTemplate.setEnableTransactionSupport(true);
        this.valueTemplate.afterPropertiesSet();
    }

    @Override
    public void add(@NonNull EmailSchedulingData emailSchedulingData) {
        if (emailSchedulingData == null) {
            throw new NullPointerException("emailSchedulingData");
        }
        this.addOps(emailSchedulingData);
    }

    protected void addOps(EmailSchedulingData emailSchedulingData) {
        String orderingKey = this.orderingKey(emailSchedulingData);
        String valueKey = emailSchedulingData.getId();
        double score = this.calculateScore(emailSchedulingData);
        BoundZSetOperations orderingZSetOps = this.orderingTemplate.boundZSetOps((Object)orderingKey);
        orderingZSetOps.add((Object)valueKey, score);
        orderingZSetOps.persist();
        BoundValueOperations valueValueOps = this.valueTemplate.boundValueOps((Object)valueKey);
        valueValueOps.set((Object)emailSchedulingData);
        valueValueOps.persist();
    }

    @Override
    public Optional<EmailSchedulingData> get(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return Optional.ofNullable(this.getOps(id));
    }

    protected EmailSchedulingData getOps(String id) {
        BoundValueOperations boundValueOps = this.valueTemplate.boundValueOps((Object)id);
        EmailSchedulingData emailSchedulingData = (EmailSchedulingData)boundValueOps.get();
        return emailSchedulingData;
    }

    @Override
    public boolean remove(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return this.removeOps(id);
    }

    protected boolean removeOps(String id) {
        EmailSchedulingData emailSchedulingData = this.getOps(id);
        if (Objects.nonNull(emailSchedulingData)) {
            this.valueTemplate.delete((Object)id);
            String orderingKey = this.orderingKey(emailSchedulingData);
            this.orderingTemplate.boundZSetOps((Object)orderingKey).remove(new Object[]{id});
            return true;
        }
        return false;
    }

    @Override
    public void addAll(@NonNull Collection<EmailSchedulingData> emailSchedulingDataList) {
        if (emailSchedulingDataList == null) {
            throw new NullPointerException("emailSchedulingDataList");
        }
        this.addAllOps(emailSchedulingDataList);
    }

    protected void addAllOps(Collection<EmailSchedulingData> emailSchedulingDataList) {
        for (EmailSchedulingData emailSchedulingData : emailSchedulingDataList) {
            this.addOps(emailSchedulingData);
        }
    }

    @Override
    public Collection<EmailSchedulingData> getNextBatch(int priorityLevel, int batchMaxSize) {
        Preconditions.checkArgument((batchMaxSize > 0 ? 1 : 0) != 0, (Object)"Batch size should be a positive integer.");
        String orderingKey = RedisBasedPersistenceServiceConstants.orderingKey(priorityLevel);
        return this.getNextBatchOps(orderingKey, batchMaxSize);
    }

    protected Collection<EmailSchedulingData> getNextBatchOps(String orderingKey, int batchMaxSize) {
        Preconditions.checkArgument((batchMaxSize > 0 ? 1 : 0) != 0, (Object)"Batch size should be a positive integer.");
        BoundZSetOperations boundZSetOperations = this.orderingTemplate.boundZSetOps((Object)orderingKey);
        long amount = boundZSetOperations.size();
        Set valueIds = boundZSetOperations.range(0L, Math.max(0L, Math.min(amount, (long)batchMaxSize) - 1L));
        return valueIds.stream().map(id -> this.getOps((String)id)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Collection<EmailSchedulingData> getNextBatch(int batchMaxSize) {
        Preconditions.checkArgument((batchMaxSize > 0 ? 1 : 0) != 0, (String)"Batch size should be a positive integer, while %s given.", (int)batchMaxSize);
        TreeSet keys = new TreeSet(this.orderingTemplate.keys((Object)(RedisBasedPersistenceServiceConstants.orderingKeyPrefix() + MATCH_ALL)));
        TreeSet<EmailSchedulingData> emailSchedulingDataSet = new TreeSet<EmailSchedulingData>(EmailSchedulingData.DEFAULT_COMPARATOR);
        for (String key : keys) {
            emailSchedulingDataSet.addAll(this.getNextBatchOps(key, batchMaxSize));
        }
        return emailSchedulingDataSet.stream().limit(Math.min(batchMaxSize, emailSchedulingDataSet.size())).collect(Collectors.toList());
    }

    @Override
    public void removeAll() {
        this.orderingTemplate.delete((Object)MATCH_ALL);
        this.valueTemplate.delete((Object)MATCH_ALL);
    }

    @Override
    public void removeAll(int priorityLevel) {
        String orderingKey = RedisBasedPersistenceServiceConstants.orderingKey(priorityLevel);
        BoundZSetOperations boundZSetOperations = this.orderingTemplate.boundZSetOps((Object)orderingKey);
        long amount = boundZSetOperations.size();
        int offset = 2000;
        IntStream.range(0, (int)Math.ceil(amount / 2000L)).parallel().forEach(i -> {
            long start = i * 2000;
            long end = Math.min(amount, start + 2000L);
            Set valueIds = boundZSetOperations.range(start, end);
            this.valueTemplate.delete((Collection)valueIds);
        });
        this.orderingTemplate.delete((Object)orderingKey);
    }

    @Override
    public void removeAll(@NonNull Collection<String> ids) {
        if (ids == null) {
            throw new NullPointerException("ids");
        }
        ids.parallelStream().forEach(id -> this.removeOps((String)id));
    }

    private String orderingKey(EmailSchedulingData emailSchedulingData) {
        return RedisBasedPersistenceServiceConstants.orderingKey(emailSchedulingData.getAssignedPriority());
    }

    private double calculateScore(EmailSchedulingData emailSchedulingData) {
        long nanos = emailSchedulingData.getScheduledDateTime().getLong(ChronoField.NANO_OF_SECOND);
        int desiredPriority = emailSchedulingData.getDesiredPriority();
        String scoreStringValue = nanos + "." + desiredPriority + Math.abs(emailSchedulingData.getId().hashCode());
        double score = new BigDecimal(scoreStringValue).doubleValue();
        return score;
    }
}

