/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.utils;

import it.ozimov.springboot.mail.model.Email;
import it.ozimov.springboot.mail.model.EmailAttachment;
import it.ozimov.springboot.mail.utils.EmailConversionException;
import it.ozimov.springboot.mail.utils.MimeMessageHelperExt;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Component;

@Component
public class EmailToMimeMessage
implements Function<Email, MimeMessage> {
    private static final Logger log = LoggerFactory.getLogger(EmailToMimeMessage.class);
    private JavaMailSender javaMailSender;

    @Autowired
    public EmailToMimeMessage(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    @Override
    public MimeMessage apply(Email email) {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        boolean isMultipart = Objects.nonNull(email.getAttachments()) && !email.getAttachments().isEmpty();
        try {
            MimeMessageHelperExt messageHelper = new MimeMessageHelperExt(mimeMessage, isMultipart, (String)com.google.common.base.Optional.fromNullable((Object)email.getEncoding()).or((Object)StandardCharsets.UTF_8.name()));
            messageHelper.setFrom(email.getFrom());
            if (Objects.nonNull(email.getReplyTo())) {
                messageHelper.setReplyTo(email.getReplyTo());
            }
            if (Objects.nonNull(email.getTo())) {
                for (InternetAddress address : email.getTo()) {
                    messageHelper.addTo(address);
                }
            }
            if (Objects.nonNull(email.getCc())) {
                for (InternetAddress address : email.getCc()) {
                    messageHelper.addCc(address);
                }
            }
            if (Objects.nonNull(email.getBcc())) {
                for (InternetAddress address : email.getBcc()) {
                    messageHelper.addBcc(address);
                }
            }
            if (isMultipart) {
                for (EmailAttachment attachment : email.getAttachments()) {
                    messageHelper.addAttachment(attachment.getAttachmentName(), (InputStreamSource)attachment.getInputStream());
                }
            }
            messageHelper.setSubject(Optional.ofNullable(email.getSubject()).orElse(""));
            messageHelper.setText(Optional.ofNullable(email.getBody()).orElse(""));
            if (Objects.nonNull(email.getSentAt())) {
                messageHelper.setSentDate(email.getSentAt());
            }
            if (Objects.nonNull(email.getReceiptTo())) {
                messageHelper.setHeaderReturnReceipt(email.getReceiptTo().getAddress());
            }
            if (Objects.nonNull(email.getDepositionNotificationTo())) {
                messageHelper.setHeaderDepositionNotificationTo(email.getDepositionNotificationTo().getAddress());
            }
            if (Objects.nonNull(email.getCustomHeaders()) && !email.getCustomHeaders().isEmpty()) {
                this.setCustomHeaders(email, mimeMessage);
            }
            mimeMessage.saveChanges();
        }
        catch (MessagingException e) {
            log.error("Error while converting DefaultEmail to MimeMessage");
            throw new EmailConversionException(e);
        }
        return mimeMessage;
    }

    protected void setCustomHeaders(Email email, MimeMessage mimeMessage) {
        email.getCustomHeaders().entrySet().stream().forEach(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                mimeMessage.setHeader(key, value);
            }
            catch (MessagingException e) {
                log.warn("Exception while setting custom email header with value {} and key {}. The MimeEmail will be created anyway but something may go wrong afterward.", new Object[]{key, value, e});
            }
        });
    }
}

