/*
 * Decompiled with CFR 0.152.
 */
package it.ozimov.springboot.mail.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.springframework.http.MediaType;

public class TikaDetector {
    private final Detector detector;

    private TikaDetector() {
        TikaConfig config = TikaConfig.getDefaultConfig();
        this.detector = config.getDetector();
    }

    public static TikaDetector tikaDetector() {
        return TikaDetectorSingletonHolder.TIKA_DETECTOR;
    }

    private static MediaType toSpringMediaType(org.apache.tika.mime.MediaType mediaType) {
        return MediaType.valueOf((String)mediaType.toString());
    }

    public MediaType detect(InputStream inputStream, String fileName) throws IOException {
        TikaInputStream stream = TikaInputStream.get((InputStream)inputStream);
        return this.detect(stream, fileName);
    }

    private MediaType detect(TikaInputStream stream, String fileName) throws IOException {
        Metadata metadata = new Metadata();
        metadata.add("resourceName", fileName);
        org.apache.tika.mime.MediaType mediaType = this.detector.detect((InputStream)Objects.requireNonNull(stream), metadata);
        return TikaDetector.toSpringMediaType(mediaType);
    }

    private static class TikaDetectorSingletonHolder {
        public static final TikaDetector TIKA_DETECTOR = new TikaDetector();

        private TikaDetectorSingletonHolder() {
        }
    }
}

