/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.DelegatingCacheLoader;

public class LocalDelegatingCacheLoader
extends DelegatingCacheLoader {
    TreeCache delegate = null;

    public LocalDelegatingCacheLoader() {
    }

    public LocalDelegatingCacheLoader(TreeCache delegate) {
        this.delegate = delegate;
    }

    public void setConfig(Properties props) {
    }

    public void setCache(TreeCache cache) {
    }

    protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
        return this.delegate.getChildrenNames(fqn);
    }

    protected Map delegateGet(Fqn name) throws Exception {
        Node n = this.delegate.get(name);
        if (n == null) {
            return null;
        }
        HashMap m = n.getData();
        if (m == null) {
            m = new HashMap(0);
        }
        return m;
    }

    protected void setDelegateCache(TreeCache delegate) {
        this.delegate = delegate;
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        return this.delegate.exists(name);
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.delegate.put(name, key, value);
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        this.delegate.put(name, attributes);
    }

    protected void delegatePut(List modifications) throws Exception {
        Iterator it = modifications.iterator();
        block8: while (it.hasNext()) {
            Modification m = (Modification)it.next();
            switch (m.getType()) {
                case 2: {
                    this.put(m.getFqn(), m.getData());
                    continue block8;
                }
                case 3: {
                    this.put(m.getFqn(), m.getData(), true);
                    continue block8;
                }
                case 1: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block8;
                }
                case 6: {
                    this.removeData(m.getFqn());
                    continue block8;
                }
                case 5: {
                    this.remove(m.getFqn(), m.getKey());
                    continue block8;
                }
                case 4: {
                    this.remove(m.getFqn());
                    continue block8;
                }
            }
            this.log.error((Object)("modification type " + m.getType() + " not known"));
        }
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.delegate.remove(name, key);
    }

    protected void delegateRemove(Fqn name) throws Exception {
        this.delegate.remove(name);
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        this.delegate.removeData(name);
    }

    protected byte[] delegateLoadEntireState() throws Exception {
        return this.delegate.getStateBytes();
    }

    protected void delegateStoreEntireState(byte[] state) throws Exception {
        this.delegate.setStateBytes(state);
    }
}

