/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.httpclient.HttpException;
import org.apache.util.HttpURL;
import org.apache.webdav.lib.WebdavResource;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerBase;

public class DavURLLister
extends URLListerBase {
    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter) throws IOException {
        return this.listMembers(baseUrl, filter, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs) throws IOException {
        ArrayList<URL> arrayList;
        WebdavResource resource = null;
        try {
            try {
                resource = new WebdavResource(baseUrl.toString());
                WebdavResource[] resources = resource.listWebdavResources();
                ArrayList<URL> urls = new ArrayList<URL>(resources.length);
                int i = 0;
                while (true) {
                    if (i >= resources.length) {
                        arrayList = urls;
                        Object var13_14 = null;
                        if (resource == null) return arrayList;
                        break;
                    }
                    WebdavResource member = resources[i];
                    HttpURL httpURL = member.getHttpURL();
                    if (filter.accept(baseUrl, httpURL.getName())) {
                        String url = httpURL.getUnescapedHttpURL();
                        if (member.isCollection()) {
                            if (!url.endsWith("/")) {
                                url = url + "/";
                            }
                            if (scanNonDottedSubDirs && DavURLLister.getFilePartFromUrl(httpURL.toURL()).indexOf(".") == -1) {
                                URL subUrl = new URL(url);
                                urls.addAll(this.listMembers(subUrl, filter, scanNonDottedSubDirs));
                            } else {
                                urls.add(new URL(url));
                            }
                        } else {
                            urls.add(new URL(url));
                        }
                    }
                    ++i;
                }
            }
            catch (HttpException e) {
                throw new IOException(e.getMessage());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (resource == null) throw throwable;
            resource.close();
            throw throwable;
        }
        resource.close();
        return arrayList;
    }

    protected static final String getFilePartFromUrl(URL source) {
        int length;
        String name = source.getPath();
        if (name.charAt((length = name.length()) - 1) == '/') {
            int start = name.lastIndexOf("/", length - 2);
            return name.substring(start, length - 2);
        }
        int start = name.lastIndexOf("/");
        return name.substring(start);
    }
}

