/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.state;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.util.Objects;
import org.jboss.util.state.AcceptableState;
import org.jboss.util.state.DefaultStateMachineModel;
import org.jboss.util.state.State;
import org.jboss.util.state.StateAdapter;
import org.jboss.util.state.StateMachine;

public class Test {
    static StateMachine machine = null;
    static StateMachine.Model originalModel = null;
    static State NEW = new State(0, "NEW");
    static State INITIALIZING = new State(1, "INITIALIZING");
    static State INITIALIZED = new State(2, "INITIALIZED");
    static State STARTING = new State(3, "STARTING");
    static State STARTED = new StateAdapter(4, "STARTED"){

        public void stateChanged(StateMachine.ChangeEvent event) {
            startedGotEvent = true;
        }
    };
    static State FAILED = new StateAdapter(100, "FAILED"){

        public void stateChanged(StateMachine.ChangeEvent event) {
            failedGotEvent = true;
        }
    };
    static State FINAL = new AcceptableState(101, "FINAL"){

        public boolean isAcceptable(State state) {
            finalChecking = true;
            return false;
        }
    };
    static boolean startedGotEvent = false;
    static boolean failedGotEvent = false;
    static boolean finalChecking = false;

    public static StateMachine.Model makeClone() {
        StateMachine.Model model = (StateMachine.Model)originalModel.clone();
        Assert.assertTrue(model.equals(originalModel), "Clone was mutated");
        return model;
    }

    public static boolean canSerialize(Serializable obj) {
        try {
            Objects.copy(obj);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\nTesting data structure equality...");
        Assert.assertTrue(new DefaultStateMachineModel().equals(new DefaultStateMachineModel()));
        HashSet<State> setA = new HashSet<State>();
        setA.add(FAILED);
        HashSet<State> setB = new HashSet<State>();
        setB.add(FAILED);
        HashSet<State> setC = new HashSet<State>();
        setC.add(FAILED);
        setC.add(NEW);
        HashSet<State> setD = new HashSet<State>();
        setD.add(FAILED);
        setD.add(STARTED);
        setD.add(NEW);
        DefaultStateMachineModel modelA = new DefaultStateMachineModel();
        modelA.addState(NEW);
        DefaultStateMachineModel modelB = new DefaultStateMachineModel();
        modelB.addState(NEW);
        DefaultStateMachineModel modelC = new DefaultStateMachineModel();
        modelC.addState(FINAL);
        DefaultStateMachineModel modelD = new DefaultStateMachineModel();
        modelD.addState(FINAL);
        modelD.addState(NEW);
        modelD.setInitialState(FINAL);
        DefaultStateMachineModel modelA1 = new DefaultStateMachineModel();
        modelA1.addState(NEW, setA);
        DefaultStateMachineModel modelB1 = new DefaultStateMachineModel();
        modelB1.addState(NEW, setB);
        DefaultStateMachineModel modelC1 = new DefaultStateMachineModel();
        modelC1.addState(FINAL, setC);
        DefaultStateMachineModel modelD1 = new DefaultStateMachineModel();
        modelD1.addState(FINAL, setD);
        modelD1.addState(NEW);
        modelD1.setInitialState(FINAL);
        DefaultStateMachineModel modelA2 = (DefaultStateMachineModel)modelA1.clone();
        DefaultStateMachineModel modelB2 = (DefaultStateMachineModel)modelB1.clone();
        DefaultStateMachineModel modelC2 = (DefaultStateMachineModel)modelC1.clone();
        DefaultStateMachineModel modelD2 = (DefaultStateMachineModel)modelD1.clone();
        Assert.assertTrue(modelA.equals(modelA));
        Assert.assertTrue(modelA.equals(modelB));
        Assert.assertTrue(modelB.equals(modelA));
        Assert.assertTrue(!modelA.equals(modelC));
        Assert.assertTrue(modelA1.equals(modelA1));
        Assert.assertTrue(modelA1.equals(modelB1));
        Assert.assertTrue(modelB1.equals(modelA1));
        Assert.assertTrue(!modelA1.equals(modelC1));
        Assert.assertTrue(modelD1.equals(modelD1));
        Assert.assertTrue(!modelD1.equals(modelA1));
        Assert.assertTrue(!modelA.equals(modelA1));
        Assert.assertTrue(!modelB.equals(modelB1));
        Assert.assertTrue(!modelC.equals(modelC1));
        Assert.assertTrue(!modelD.equals(modelD1));
        Assert.assertTrue(modelA1.equals(modelA2));
        Assert.assertTrue(modelB1.equals(modelB2));
        Assert.assertTrue(modelC1.equals(modelC2));
        Assert.assertTrue(modelD1.equals(modelD2));
        modelD.removeState(NEW);
        System.out.println("\nTesting serializaion...");
        Assert.assertTrue(Test.canSerialize(new State(0, "")));
        Assert.assertTrue(Test.canSerialize(new StateAdapter(0, "")));
        Assert.assertTrue(Test.canSerialize(new AcceptableState(0, ""){

            public boolean isAcceptable(State state) {
                return false;
            }
        }));
        Assert.assertTrue(Test.canSerialize(new DefaultStateMachineModel()));
        System.out.println("\nSetting up model for tests...");
        DefaultStateMachineModel model = new DefaultStateMachineModel();
        Assert.assertTrue(model.equals(new DefaultStateMachineModel()));
        Assert.assertTrue(model.equals((StateMachine.Model)model.clone()));
        Set set = model.addState(NEW, INITIALIZING);
        Assert.assertTrue(set == null, "1");
        Assert.assertTrue(!model.equals(new DefaultStateMachineModel()));
        Assert.assertTrue(model.equals((StateMachine.Model)model.clone()));
        model.addState(INITIALIZING, new State[]{INITIALIZED, FAILED});
        model.addState(INITIALIZED, new State[]{STARTING, FAILED});
        model.addState(STARTING, INITIALIZED);
        Assert.assertTrue(model.equals((StateMachine.Model)model.clone()));
        model.addState(STARTED, INITIALIZED);
        set = model.addState(STARTED, STARTING);
        Assert.assertTrue(set.size() == 1 && set.contains(INITIALIZED));
        Assert.assertTrue(model.equals((StateMachine.Model)model.clone()));
        model.addState(FINAL);
        Assert.assertTrue(model.equals((StateMachine.Model)model.clone()));
        HashSet mostStates = new HashSet(model.states());
        mostStates.remove(NEW);
        mostStates.remove(FAILED);
        model.addState(FAILED, mostStates);
        model.setInitialState(NEW);
        originalModel = (DefaultStateMachineModel)Objects.copy(model);
        System.out.println("Original model: " + originalModel);
        System.out.println("\nTesting clonability of model...");
        Assert.assertTrue(model.equals(Test.makeClone()));
        StateMachine.Model aModel = (StateMachine.Model)model.clone();
        Assert.assertTrue(model.equals(aModel));
        Assert.assertTrue(aModel.equals(model));
        aModel.clear();
        Assert.assertTrue(!model.equals(aModel));
        aModel = (StateMachine.Model)model.clone();
        Assert.assertTrue(model.equals(aModel));
        aModel.removeState(FINAL);
        Assert.assertTrue(!model.equals(aModel));
        aModel = (StateMachine.Model)model.clone();
        Assert.assertTrue(model.equals(aModel));
        aModel.addState(new State(FINAL.getValue(), "NEW FINAL"));
        Assert.assertTrue(model.equals(aModel));
        machine = new StateMachine(Test.makeClone());
        System.out.println(machine);
        System.out.println();
        Test.test("new machine");
        Assert.assertTrue(finalChecking, "Acceptable State broken");
        Assert.assertTrue(startedGotEvent, "ChangeListener broken");
        Assert.assertTrue(failedGotEvent, "ChangeListener broken");
        machine.reset();
        Test.test("reset");
        machine = new StateMachine(Test.makeClone());
        Test.test("model cloning");
        aModel = Test.makeClone();
        aModel.removeState(FAILED);
        machine = new StateMachine(aModel);
        try {
            Test.test("model cloning with removal");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue(e.getMessage().equals("State must be STARTING; cannot accept state: FAILED; state=INITIALIZED"));
        }
        machine = new StateMachine(Test.makeClone());
        Test.test("model cloning after removal");
        machine = new StateMachine(Test.makeClone());
        machine.addChangeListener(new StateMachine.ChangeListener(){

            public void stateChanged(StateMachine.ChangeEvent event) {
                throw new RuntimeException("ChangeListener");
            }
        });
        try {
            machine.transition(INITIALIZING);
            Assert.assertTrue(false);
        }
        catch (RuntimeException e) {
            Assert.assertTrue(e.getMessage().equals("ChangeListener"));
            Assert.assertTrue(machine.getCurrentState().equals(INITIALIZING));
        }
        machine = new StateMachine(Test.makeClone());
        AcceptableState state = new AcceptableState(100, "FAILED"){

            public boolean isAcceptable(State state) {
                throw new RuntimeException("Accetable");
            }
        };
        aModel = machine.getModel();
        set = aModel.addState((State)state, mostStates);
        machine.transition(INITIALIZING);
        Assert.assertTrue(machine.getCurrentState().equals(INITIALIZING));
        machine.transition(FAILED);
        Assert.assertTrue(machine.getCurrentState().equals(FAILED));
        try {
            machine.transition(FINAL);
        }
        catch (Exception e) {
            Assert.assertTrue(e.getMessage().equals("Accetable"));
            Assert.assertTrue(machine.getCurrentState().equals(FAILED));
        }
        System.out.println("\nDone.");
    }

    public static void dumpState(State state) {
        Set acceptable = machine.getModel().states();
        System.out.println(state + " accepts " + acceptable);
    }

    public static void dumpStates(Set set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Test.dumpState((State)iter.next());
        }
    }

    public static void test(String name) {
        System.out.println("\nTesting " + name + "...");
        StateMachine.Model model = machine.getModel();
        Assert.assertTrue(model.getInitialState().equals(NEW));
        Assert.assertTrue(machine.getCurrentState().equals(NEW));
        machine.transition(INITIALIZING);
        Assert.assertTrue(machine.getCurrentState().equals(INITIALIZING));
        machine.transition(INITIALIZED);
        Assert.assertTrue(machine.getCurrentState().equals(INITIALIZED));
        try {
            machine.transition(NEW);
            Assert.assertTrue(false);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue(machine.getCurrentState().equals(INITIALIZED));
        }
        machine.transition(FAILED);
        Assert.assertTrue(machine.getCurrentState().equals(FAILED));
        machine.transition(FINAL);
        Assert.assertTrue(machine.getCurrentState().equals(FINAL));
        try {
            machine.transition(NEW);
            Assert.assertTrue(false);
        }
        catch (IllegalStateException e) {
            Assert.assertTrue(machine.getCurrentState().equals(FINAL));
        }
    }

    public static void dumpState() {
        System.out.print("Current state: ");
        Test.dumpState(machine.getCurrentState());
    }

    private static class Assert {
        private Assert() {
        }

        public static void assertTrue(boolean rv) {
            Assert.assertTrue(rv, null);
        }

        public static void assertTrue(boolean rv, String msg) {
            if (!rv && msg != null) {
                System.out.println(rv + ": " + msg);
            } else {
                System.out.println(rv);
            }
        }
    }
}

