/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.Logger;
import org.jboss.net.protocol.DelegatingURLConnection;

public class ResourceURLConnection
extends DelegatingURLConnection {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.net.protocol.resource.ResourceURLConnection"));

    public ResourceURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
    }

    protected URL makeDelegateUrl(URL url) throws MalformedURLException, IOException {
        ClassLoader cl;
        URL target;
        String name = url.getHost();
        String file = url.getFile();
        if (file != null && !file.equals("")) {
            name = new JBossStringBuilder().append(name).append(file).toString();
        }
        if ((target = (cl = Thread.currentThread().getContextClassLoader()).getResource(name)) == null) {
            cl = ClassLoader.getSystemClassLoader();
            target = cl.getResource(name);
        }
        if (target == null) {
            throw new FileNotFoundException(new JBossStringBuilder().append("Could not locate resource: ").append(name).toString());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)new JBossStringBuilder().append("Target resource URL: ").append((Object)target).toString());
            try {
                log.trace((Object)new JBossStringBuilder().append("Target resource URL connection: ").append((Object)target.openConnection()).toString());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return new URL(target.toExternalForm());
    }
}

