/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.util.ThrowableListener;

public final class ThrowableHandler {
    protected static List listeners = Collections.synchronizedList(new ArrayList());

    public static void addThrowableListener(ThrowableListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeThrowableListener(ThrowableListener listener) {
        listeners.remove(listener);
    }

    protected static void fireOnThrowable(int type, Throwable t) {
        Object[] list = listeners.toArray();
        for (int i = 0; i < list.length; ++i) {
            ((ThrowableListener)list[i]).onThrowable(type, t);
        }
    }

    public static void add(int type, Throwable t) {
        if (t == null) {
            return;
        }
        try {
            ThrowableHandler.fireOnThrowable(type, t);
        }
        catch (Throwable bad) {
            System.err.println(new JBossStringBuilder().append("Unable to handle throwable: ").append((Object)t).append(" because of:").toString());
            bad.printStackTrace();
        }
    }

    public static void add(Throwable t) {
        ThrowableHandler.add(0, t);
    }

    public static void addError(Throwable t) {
        ThrowableHandler.add(1, t);
    }

    public static void addWarning(Throwable t) {
        ThrowableHandler.add(1, t);
    }

    public static interface Type {
        public static final int UNKNOWN = 0;
        public static final int ERROR = 1;
        public static final int WARNING = 2;
    }
}

