/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.deadlock;

import java.util.HashMap;
import java.util.HashSet;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.util.deadlock.ApplicationDeadlockException;
import org.jboss.util.deadlock.Resource;

public class DeadlockDetector {
    public static DeadlockDetector singleton = new DeadlockDetector();
    protected HashMap waiting = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deadlockDetection(Object holder, Resource resource) throws ApplicationDeadlockException {
        HashSet<Object> set = new HashSet<Object>();
        set.add(holder);
        Object checkHolder = resource.getResourceHolder();
        HashMap hashMap = this.waiting;
        synchronized (hashMap) {
            this.addWaiting(holder, resource);
            while (checkHolder != null) {
                Resource waitingFor = (Resource)this.waiting.get(checkHolder);
                Object holding = null;
                if (waitingFor != null) {
                    holding = waitingFor.getResourceHolder();
                }
                if (holding != null) {
                    if (set.contains(holding)) {
                        String msg = new JBossStringBuilder().append("Application deadlock detected, resource=").append((Object)resource).append(", holder=").append(holder).append(", waitingResource=").append((Object)waitingFor).append(", waitingResourceHolder=").append(holding).toString();
                        throw new ApplicationDeadlockException(msg, true);
                    }
                    set.add(holding);
                }
                checkHolder = holding;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaiting(Object holder, Resource resource) {
        HashMap hashMap = this.waiting;
        synchronized (hashMap) {
            this.waiting.put(holder, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWaiting(Object holder) {
        HashMap hashMap = this.waiting;
        synchronized (hashMap) {
            this.waiting.remove(holder);
        }
    }
}

