/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.Logger;

public final class Streams {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.util.stream.Streams"));
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static boolean close(InputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public static boolean close(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public static boolean close(Object stream) {
        boolean success = false;
        if (stream instanceof InputStream) {
            success = Streams.close((InputStream)stream);
        } else if (stream instanceof OutputStream) {
            success = Streams.close((OutputStream)stream);
        } else {
            throw new IllegalArgumentException("stream is not an InputStream or OutputStream");
        }
        return success;
    }

    public static boolean close(InputStream[] streams) {
        boolean success = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.close(streams[i]);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean close(OutputStream[] streams) {
        boolean success = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.close(streams[i]);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean close(Object[] streams) {
        boolean success = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.close(streams[i]);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean fclose(OutputStream stream) {
        return Streams.flush(stream) && Streams.close(stream);
    }

    public static boolean fclose(OutputStream[] streams) {
        boolean success = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.fclose(streams[i]);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static boolean flush(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.flush();
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public static boolean flush(OutputStream[] streams) {
        boolean success = true;
        for (int i = 0; i < streams.length; ++i) {
            boolean rv = Streams.flush(streams[i]);
            if (rv) continue;
            success = false;
        }
        return success;
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int read;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)new JBossStringBuilder().append("copying ").append((Object)input).append(" to ").append((Object)output).append(" with buffer size: ").append(buffer.length).toString());
        }
        while ((read = input.read(buffer)) != -1) {
            output.write(buffer, 0, read);
            total += (long)read;
            if (!trace) continue;
            log.trace((Object)new JBossStringBuilder().append("bytes read: ").append(read).append("; total bytes read: ").append(total).toString());
        }
        return total;
    }

    public static long copy(InputStream input, OutputStream output, int size) throws IOException {
        return Streams.copy(input, output, new byte[size]);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 2048);
    }

    public static long copyb(InputStream input, OutputStream output) throws IOException {
        if (!(input instanceof BufferedInputStream)) {
            input = new BufferedInputStream(input);
        }
        if (!(output instanceof BufferedOutputStream)) {
            output = new BufferedOutputStream(output);
        }
        long bytes = Streams.copy(input, output, 2048);
        output.flush();
        return bytes;
    }

    public static long copySome(InputStream input, OutputStream output, byte[] buffer, long length) throws IOException {
        int read;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        int readLength = Math.min((int)length, buffer.length);
        if (trace) {
            log.trace((Object)new JBossStringBuilder().append("initial read length: ").append(readLength).toString());
        }
        while (readLength != 0 && (read = input.read(buffer, 0, readLength)) != -1) {
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("read bytes: ").append(read).toString());
            }
            output.write(buffer, 0, read);
            total += (long)read;
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("total bytes read: ").append(total).toString());
            }
            readLength = Math.min((int)(length - total), buffer.length);
            if (!trace) continue;
            log.trace((Object)new JBossStringBuilder().append("next read length: ").append(readLength).toString());
        }
        return total;
    }

    public static long copySome(InputStream input, OutputStream output, int size, long length) throws IOException {
        return Streams.copySome(input, output, new byte[size], length);
    }

    public static long copySome(InputStream input, OutputStream output, long length) throws IOException {
        return Streams.copySome(input, output, 2048, length);
    }
}

