/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml.catalog.readers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.Vector;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.util.xml.catalog.Catalog;
import org.jboss.util.xml.catalog.CatalogEntry;
import org.jboss.util.xml.catalog.CatalogException;
import org.jboss.util.xml.catalog.readers.CatalogReader;

public class TextCatalogReader
implements CatalogReader {
    protected InputStream catfile = null;
    protected int[] stack = new int[3];
    protected Stack tokenStack = new Stack();
    protected int top = -1;
    protected boolean caseSensitive = false;

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void readCatalog(Catalog catalog, String fileUrl) throws MalformedURLException, IOException {
        URL catURL = null;
        try {
            catURL = new URL(fileUrl);
        }
        catch (MalformedURLException e) {
            catURL = new URL(new JBossStringBuilder().append("file:///").append(fileUrl).toString());
        }
        URLConnection urlCon = catURL.openConnection();
        try {
            this.readCatalog(catalog, urlCon.getInputStream());
        }
        catch (FileNotFoundException e) {
            catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", catURL.toString());
        }
    }

    public void readCatalog(Catalog catalog, InputStream is) throws MalformedURLException, IOException {
        this.catfile = is;
        if (this.catfile == null) {
            return;
        }
        Vector<String> unknownEntry = null;
        while (true) {
            String token;
            if ((token = this.nextToken()) == null) {
                if (unknownEntry != null) {
                    catalog.unknownEntry(unknownEntry);
                    unknownEntry = null;
                }
                this.catfile.close();
                this.catfile = null;
                return;
            }
            String entryToken = null;
            entryToken = this.caseSensitive ? token : token.toUpperCase();
            try {
                int type = CatalogEntry.getEntryType(entryToken);
                int numArgs = CatalogEntry.getEntryArgCount(type);
                Vector<String> args = new Vector<String>();
                if (unknownEntry != null) {
                    catalog.unknownEntry(unknownEntry);
                    unknownEntry = null;
                }
                for (int count = 0; count < numArgs; ++count) {
                    args.addElement(this.nextToken());
                }
                catalog.addEntry(new CatalogEntry(entryToken, args));
                continue;
            }
            catch (CatalogException cex) {
                if (cex.getExceptionType() == 3) {
                    if (unknownEntry == null) {
                        unknownEntry = new Vector<String>();
                    }
                    unknownEntry.addElement(token);
                    continue;
                }
                if (cex.getExceptionType() != 2) continue;
                catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", token);
                unknownEntry = null;
                continue;
            }
            break;
        }
    }

    protected void finalize() {
        if (this.catfile != null) {
            try {
                this.catfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.catfile = null;
    }

    protected String nextToken() throws IOException {
        int nextch;
        int ch;
        String token = "";
        if (!this.tokenStack.empty()) {
            return (String)this.tokenStack.pop();
        }
        block0: while (true) {
            ch = this.catfile.read();
            while (ch <= 32) {
                ch = this.catfile.read();
                if (ch >= 0) continue;
                return null;
            }
            nextch = this.catfile.read();
            if (nextch < 0) {
                return null;
            }
            if (ch != 45 || nextch != 45) break;
            ch = 32;
            nextch = this.nextChar();
            while (true) {
                if (ch == 45 && nextch == 45) continue block0;
                ch = nextch;
                nextch = this.nextChar();
            }
            break;
        }
        this.stack[++this.top] = nextch;
        this.stack[++this.top] = ch;
        ch = this.nextChar();
        if (ch == 34 || ch == 39) {
            int quote = ch;
            while ((ch = this.nextChar()) != quote) {
                char[] chararr = new char[]{(char)ch};
                String s = new String(chararr);
                token = token.concat(s);
            }
            return token;
        }
        while (ch > 32) {
            nextch = this.nextChar();
            if (ch == 45 && nextch == 45) {
                this.stack[++this.top] = ch;
                this.stack[++this.top] = nextch;
                return token;
            }
            char[] chararr = new char[]{(char)ch};
            String s = new String(chararr);
            token = token.concat(s);
            ch = nextch;
        }
        return token;
    }

    protected int nextChar() throws IOException {
        if (this.top < 0) {
            return this.catfile.read();
        }
        return this.stack[this.top--];
    }
}

