/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.IOUtil;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.UriManager;
import jmaki.runtime.WidgetResourceException;
import jmaki.runtime.config.ApiKey;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.GlobalConfig;

public class AjaxCommonRenderer {
    private AjaxContext ajx;
    private GlobalConfig globalConfig;
    private Config widgetConfig;
    private ResourceManager resourceManager;
    private UriManager uriManager;
    private Writer out;
    private String globalWebRoot;
    private String resourcesDir;
    private String name;
    private String uuid;
    private String template;
    private String onLoad;
    private String style;
    private String type;
    private boolean embedded;
    private String args;
    private String script;
    private String service;
    private String value;
    private String xhpMapping;
    private String selected;
    private String valueCallback;
    private String widgetDir;
    private String absoluteWidgetPath;
    private Iterator libs;
    private Iterator styles;
    private boolean isWidgetWebAppResource;
    private boolean isGlobalConfigWebAppResource;
    private URL templateURL = null;
    private Map widgetProperties;
    private static Logger logger;

    public void setName(String name) {
        this.name = name;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setOnLoad(String onLoad) {
        this.onLoad = onLoad;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public void setValueCallback(String valueCallback) {
        this.valueCallback = valueCallback;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public AjaxCommonRenderer(AjaxContext ajx) throws AjaxException {
        this.ajx = ajx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws AjaxException {
        String tmpScript;
        this.globalConfig = this.ajx.getConfig();
        this.resourceManager = this.ajx.getResourceHandler();
        String widgetPath = this.resourceManager.getWidgetDir(this.name);
        String widgetDir = null;
        if (this.script == null) {
            this.script = "component.js";
        }
        if (this.resourceManager.isWebAppResource(tmpScript = IOUtil.resolvePath(widgetDir = this.ajx.getWorkingDir() + widgetPath, this.script))) {
            this.script = tmpScript;
            this.isWidgetWebAppResource = true;
        } else {
            widgetDir = this.resourceManager.getWebResourcePath() + widgetPath;
            tmpScript = IOUtil.resolvePath(widgetDir, this.script);
            if (this.resourceManager.isWebAppResource(tmpScript)) {
                this.script = tmpScript;
                this.isWidgetWebAppResource = true;
            } else {
                widgetDir = this.resourceManager.getResourcesDir() + widgetPath;
                tmpScript = IOUtil.resolvePath(widgetDir, this.script);
                if (!this.resourceManager.isClassPathResource(tmpScript)) throw new WidgetResourceException("unable to locate '" + this.script + "' in '" + this.ajx.getWorkingDir() + widgetPath + "', '" + this.resourceManager.getWebResourcePath() + widgetPath + "' and ClassPath 'META-INF'" + this.resourceManager.getResourcesDir() + widgetPath + "'");
                this.script = tmpScript;
                this.isWidgetWebAppResource = false;
            }
        }
        this.uriManager = this.ajx.getUriManager();
        this.out = this.ajx.getWriter();
        if (this.uuid == null) {
            this.uuid = this.name + "" + this.ajx.getUniqueId();
            this.uuid = this.uuid.replace('.', '_');
        }
        this.isGlobalConfigWebAppResource = this.globalConfig.isGlobalConfigWebAppResource();
        this.resourcesDir = this.resourceManager.getResourcesDir();
        this.style = this.style == null ? widgetDir + "/component.css" : IOUtil.resolvePath(widgetDir, this.style);
        if (this.template == null) {
            String templatePath = widgetDir + "/component.htm";
            if (this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath)) {
                this.template = templatePath;
            } else {
                templatePath = templatePath + "l";
                if (!(this.isWidgetWebAppResource ? this.resourceManager.isWebAppResource(templatePath) : this.resourceManager.isClassPathResource(templatePath))) throw new WidgetResourceException("Failed to locate '" + templatePath + "' for widget '" + this.name + "'");
                this.template = templatePath;
            }
        } else {
            this.template = IOUtil.resolvePath(widgetDir, this.template);
        }
        this.widgetConfig = this.globalConfig.getConfig(this.name, widgetDir);
        this.libs = this.widgetConfig.getLibs();
        this.styles = this.widgetConfig.getStyles();
        this.absoluteWidgetPath = this.isWidgetWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, widgetDir) : this.uriManager.buildClassPathResourceReference(this.ajx, widgetDir);
        this.globalWebRoot = this.isGlobalConfigWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, "") : this.uriManager.buildClassPathResourceReference(this.ajx, "");
        this.xhpMapping = this.ajx.getXhpMapping();
        if (this.xhpMapping == null) {
            this.xhpMapping = "/xhp";
        }
        AjaxCommonRenderer.getLogger().finest("uuid: '" + this.uuid + "', widgettype: '" + this.name + "', globalWebRoot: '" + this.globalWebRoot + "', resourcesDir: '" + this.resourcesDir + "', widgetdir: '" + widgetDir + "', absoluteWidgetPath: '" + this.absoluteWidgetPath + "', template: '" + this.template + "', style: '" + this.style + "', script: '" + this.script + "', xhpMapping: '" + this.xhpMapping + "', development-mode: '" + (this.ajx.getUseCache() ? "off'" : "on'"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doProcess() throws IOException, AjaxException {
        block18: {
            try {
                this.init();
                if (!this.ajx.isBootstrapScriptWritten()) {
                    this.writeLib(this.resourcesDir + "/jmaki.js", this.isGlobalConfigWebAppResource);
                    this.writeScript("jmaki.webRoot='" + this.ajx.getApplicationRoot() + "';" + "jmaki.resourcesRoot ='" + this.resourcesDir + "';" + "jmaki.xhp ='" + this.xhpMapping + "';");
                    this.ajx.setBootstrapScriptWritten(true);
                }
                while (this.libs.hasNext()) {
                    String lib = (String)this.libs.next();
                    if (this.ajx.isLibraryWritten(lib)) continue;
                    Iterator apiKeys = this.widgetConfig.getApiKeys();
                    while (apiKeys.hasNext()) {
                        ApiKey apiKey = (ApiKey)apiKeys.next();
                        String targetURL = apiKey.getUrl();
                        if ((targetURL == null || !targetURL.equals(this.globalWebRoot)) && !targetURL.equals("*")) continue;
                        lib = lib + apiKey.getKey();
                        break;
                    }
                    String preload = null;
                    preload = this.widgetConfig.getPreLoad();
                    if (preload != null) {
                        this.writeScript(preload);
                    }
                    this.writeLib(lib);
                    String postload = null;
                    postload = this.widgetConfig.getPostLoad();
                    if (postload != null) {
                        this.writeScript(postload);
                    }
                    this.ajx.setLibraryWritten(lib);
                }
                while (this.styles.hasNext()) {
                    String style = (String)this.styles.next();
                    if (this.ajx.isStyleWritten(style)) continue;
                    this.writeStyle(style, this.isWidgetWebAppResource);
                    this.ajx.setStyleWritten(style);
                }
                if (!this.ajx.isStyleWritten(this.style)) {
                    this.writeStyle(this.style, this.isWidgetWebAppResource);
                    this.ajx.setStyleWritten(this.style);
                }
                if (!this.ajx.isLibraryWritten(this.script)) {
                    this.writeLib(this.script, this.isWidgetWebAppResource);
                    this.ajx.setLibraryWritten(this.script);
                }
                this.writeTemplate(this.template);
                this.widgetProperties = new HashMap();
                this.widgetProperties.put("uuid", this.uuid);
                this.widgetProperties.put("name", this.name);
                this.widgetProperties.put("widgetDir", this.absoluteWidgetPath);
                if (this.selected != null) {
                    this.widgetProperties.put("selected", this.selected);
                }
                if (this.service != null) {
                    this.widgetProperties.put("service", this.service);
                }
                if (this.valueCallback != null) {
                    this.widgetProperties.put("valueCallback", this.valueCallback);
                }
                if (this.value != null) {
                    this.widgetProperties.put("value", this.value);
                }
                if (this.args != null) {
                    this.widgetProperties.put("args", this.args);
                }
                this.writeScript("jmaki.addWidget(" + IOUtil.createJavaScriptObject(this.widgetProperties) + ");");
                Object var6_5 = null;
                if (this.widgetProperties != null) {
                    this.widgetProperties.clear();
                    this.widgetProperties = null;
                }
                if (this.ajx.getUseCache()) break block18;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.widgetProperties != null) {
                    this.widgetProperties.clear();
                    this.widgetProperties = null;
                }
                if (!this.ajx.getUseCache()) {
                    this.ajx.discardConfig();
                }
                this.ajx = null;
                this.widgetConfig = null;
                this.resourceManager = null;
                this.uriManager = null;
                this.out = null;
                this.libs = null;
                this.styles = null;
                this.template = null;
                this.templateURL = null;
                this.name = null;
                this.script = null;
                this.widgetDir = null;
                throw throwable;
            }
            this.ajx.discardConfig();
        }
        this.ajx = null;
        this.widgetConfig = null;
        this.resourceManager = null;
        this.uriManager = null;
        this.out = null;
        this.libs = null;
        this.styles = null;
        this.template = null;
        this.templateURL = null;
        this.name = null;
        this.script = null;
        this.widgetDir = null;
    }

    private void writeTemplate(String template) throws IOException {
        URL templateURL = this.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(template) : this.resourceManager.locateClassPathResource(template);
        StringBuffer templateBuffer = null;
        try {
            templateBuffer = IOUtil.loadResource(templateURL.openStream(), null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new WidgetResourceException("failed to load 'component.htm' for widget '" + this.name + "'", ioe);
        }
        IOUtil.replace(templateBuffer, "${uuid}", this.uuid);
        if (this.service != null) {
            IOUtil.replace(templateBuffer, "${service}", this.service);
        }
        if (this.value != null) {
            if (this.value.startsWith("@{")) {
                IOUtil.replace(templateBuffer, "${value}", "");
            } else {
                IOUtil.replace(templateBuffer, "${value}", this.value);
            }
        }
        IOUtil.replace(templateBuffer, "${webRoot}", this.globalWebRoot);
        IOUtil.replace(templateBuffer, "${widgetDir}", this.absoluteWidgetPath);
        this.out.write(templateBuffer.toString());
    }

    private void writeScript(String script) throws IOException {
        this.out.write("<script type=\"text/javascript\">" + script + "</script>\n");
    }

    private void writeLib(String lib) throws IOException {
        this.writeLib(lib, this.resourceManager.isWebAppResource(lib));
    }

    private void writeLib(String lib, boolean isWebAppResource) throws IOException {
        if (!IOUtil.isExternalUri(lib)) {
            lib = isWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, lib) : this.uriManager.buildClassPathResourceReference(this.ajx, lib);
        }
        this.out.write("<script type=\"text/javascript\" src=\"" + lib + "\"></script>\n");
    }

    private void writeStyle(String style, boolean isWebAppResource) throws IOException {
        if (!IOUtil.isExternalUri(style)) {
            style = isWebAppResource ? this.uriManager.buildWebAppResourceReference(this.ajx, style) : this.uriManager.buildClassPathResourceReference(this.ajx, style);
        }
        this.out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + style + "\"></link>\n");
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("jmaki.runtime.Log");
        }
        return logger;
    }
}

