/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.Writer;
import java.util.HashSet;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmaki.runtime.AjaxException;
import jmaki.runtime.AjaxGlobalObjects;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.UriManager;
import jmaki.runtime.UriManagerFactory;
import jmaki.runtime.config.GlobalConfig;
import jmaki.runtime.jsf.Util;

public class AjaxContext {
    private Writer out = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ServletContext ctx = null;
    private HashSet writtenLibs = new HashSet();
    private HashSet writtenStyles = new HashSet();
    private boolean bootstrapScriptWritten = false;
    private String webRoot = null;
    private String applicationRoot = null;
    private String servletRoot = null;
    private String xhpMapping = null;
    private GlobalConfig config;
    private ResourceManager resourceManager;
    private UriManager uriManager;
    private boolean isJsf = false;
    private boolean isExtensionMapped;
    private int counter = 0;
    private boolean useCache;
    private static final String GLOBALOBJECTS = "jmaki_globalobjects";
    private static final String AJAXCONTEXT = "jmaki_ajaxcontext";

    public static final AjaxContext getInstance(ServletContext ctx, HttpServletRequest req, HttpServletResponse res, Writer out) throws AjaxException {
        AjaxContext ajaxContext = null;
        ajaxContext = (AjaxContext)req.getAttribute(AJAXCONTEXT);
        if (ajaxContext == null) {
            ajaxContext = new AjaxContext(ctx, req, res, out);
            req.setAttribute(AJAXCONTEXT, (Object)ajaxContext);
        }
        if (!ajaxContext.useCache) {
            ajaxContext.config = new GlobalConfig(ajaxContext.resourceManager);
        }
        return ajaxContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AjaxContext(ServletContext ctx, HttpServletRequest req, HttpServletResponse res, Writer out) throws AjaxException {
        AjaxGlobalObjects globalObjects = null;
        globalObjects = (AjaxGlobalObjects)ctx.getAttribute(GLOBALOBJECTS);
        if (globalObjects == null) {
            AjaxContext ajaxContext = this;
            synchronized (ajaxContext) {
                globalObjects = (AjaxGlobalObjects)ctx.getAttribute(GLOBALOBJECTS);
                if (globalObjects == null) {
                    globalObjects = new AjaxGlobalObjects();
                    try {
                        if (FacesContext.getCurrentInstance() != null) {
                            this.isJsf = true;
                            globalObjects.setIsJsf(true);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String useCacheParam = ctx.getInitParameter("jmaki-development-mode");
                    boolean useCache = useCacheParam == null || !useCacheParam.equalsIgnoreCase("true");
                    globalObjects.setUseCache(useCache);
                    this.resourceManager = new ResourceManager(ctx, useCache);
                    globalObjects.setResourceManager(this.resourceManager);
                    if (useCache) {
                        globalObjects.setGlobalConfig(new GlobalConfig(this.resourceManager));
                    }
                    globalObjects.setUriManager(this.getNewUriManagerInstance(ctx));
                    globalObjects.setXhpMapping(ctx.getInitParameter("jmaki-xhp-mapping"));
                    ctx.setAttribute(GLOBALOBJECTS, (Object)globalObjects);
                }
            }
        }
        if (this.isJsf = globalObjects.getIsJsf()) {
            FacesContext context = FacesContext.getCurrentInstance();
            String facesMapping = Util.getFacesMapping(context);
            this.isExtensionMapped = facesMapping.startsWith(".");
        }
        this.useCache = globalObjects.getUseCache();
        this.resourceManager = globalObjects.getResourceHandler();
        if (this.useCache) {
            this.config = globalObjects.getGlobalConfig();
        }
        this.uriManager = globalObjects.getUriManager();
        this.xhpMapping = globalObjects.getXhpMapping();
        this.request = req;
        this.response = res;
        this.ctx = ctx;
        this.out = out;
    }

    public void discardConfig() throws AjaxException {
        if (this.useCache) {
            throw new AjaxException("calling discardConfig() is illegal if not in development-mode");
        }
        this.config.discard();
    }

    private UriManager getNewUriManagerInstance(ServletContext ctx) throws AjaxException {
        String uriManagerFactoryClassName = ctx.getInitParameter("jmaki-urimanagerfactory");
        if (uriManagerFactoryClassName == null) {
            uriManagerFactoryClassName = this.isJsf() ? "jmaki.runtime.jsf.JsfUriManagerImpl" : "jmaki.runtime.jsp.JspUriManagerImpl";
        }
        try {
            Class<?> clasz = Class.forName(uriManagerFactoryClassName);
            return ((UriManagerFactory)clasz.newInstance()).getInstance(ctx);
        }
        catch (Exception e) {
            throw new AjaxException("failed to instantiate UriManagerFactory '" + uriManagerFactoryClassName + "'", e);
        }
    }

    public Writer getWriter() {
        return this.out;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getContext() {
        return this.ctx;
    }

    public GlobalConfig getConfig() {
        return this.config;
    }

    public ResourceManager getResourceHandler() {
        return this.resourceManager;
    }

    public UriManager getUriManager() {
        return this.uriManager;
    }

    public boolean isBootstrapScriptWritten() {
        return this.bootstrapScriptWritten;
    }

    public void setBootstrapScriptWritten(boolean arg) {
        this.bootstrapScriptWritten = arg;
    }

    public boolean isLibraryWritten(String lib) {
        return this.writtenLibs.contains(lib);
    }

    public void setLibraryWritten(String lib) {
        this.writtenLibs.add(lib);
    }

    public boolean isStyleWritten(String style) {
        return this.writtenStyles.contains(style);
    }

    public void setStyleWritten(String style) {
        this.writtenStyles.add(style);
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public boolean isJsf() {
        return this.isJsf;
    }

    public boolean getIsExtensionMapped() {
        return this.isExtensionMapped;
    }

    public int getUniqueId() {
        return this.counter++;
    }

    public String getWorkingDir() {
        String basePath = this.request.getRequestURI();
        String workingDir = "";
        int first = basePath.indexOf("/", 1);
        int last = basePath.lastIndexOf("/");
        if (first != -1 && last != -1) {
            workingDir = basePath.substring(first, last);
        }
        return workingDir;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            StringBuffer webRootBuffer = new StringBuffer(this.getScheme() + "://").append(this.request.getServerName());
            if (this.request.getServerPort() != 80) {
                webRootBuffer.append(":").append(this.request.getServerPort());
            }
            this.webRoot = webRootBuffer.toString();
        }
        return this.webRoot;
    }

    public String getApplicationRoot() {
        if (this.applicationRoot == null) {
            this.applicationRoot = this.getWebRoot() + this.request.getContextPath();
        }
        return this.applicationRoot;
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServletRoot() {
        if (this.servletRoot == null) {
            this.servletRoot = this.getApplicationRoot() + this.request.getServletPath();
        }
        return this.servletRoot;
    }

    public String getXhpMapping() {
        return this.xhpMapping;
    }
}

