/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import jmaki.runtime.config.WidgetConfigException;
import org.json.JSONException;
import org.json.JSONObject;

public class IOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject loadJSONObject(InputStream in) throws JSONException, IOException {
        ByteArrayOutputStream out = null;
        byte[] buffer = new byte[1024];
        int read = 0;
        out = new ByteArrayOutputStream();
        try {
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            out.flush();
            JSONObject jSONObject = new JSONObject(out.toString());
            return jSONObject;
        }
        finally {
            out.close();
            in.close();
        }
    }

    public static void replace(StringBuffer buff, String target, String replacement) {
        if (buff == null || target == null || replacement == null) {
            return;
        }
        for (int index = 0; index < buff.length() && (index = buff.indexOf(target)) != -1; index += replacement.length() + 1) {
            buff.replace(index, index + target.length(), replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer loadResource(InputStream stream, String encoding) throws IOException {
        StringBuffer buffer = new StringBuffer();
        BufferedReader bufReader = null;
        String curLine = null;
        try {
            InputStreamReader inputStreamReader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
            bufReader = new BufferedReader(inputStreamReader);
            while (null != (curLine = bufReader.readLine())) {
                buffer.append(curLine + "\n");
            }
        }
        finally {
            if (bufReader != null) {
                bufReader.close();
            }
        }
        return buffer;
    }

    public static StringBuffer createJavaScriptObject(Map p) {
        return IOUtil.createJavaScriptObject(p, false);
    }

    public static StringBuffer createJavaScriptObject(Map p, boolean json) {
        StringBuffer buff = new StringBuffer("{");
        Iterator it = p.entrySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next().getKey();
            Object val = p.get(key);
            if (val != null && val instanceof Map) {
                val = IOUtil.createJavaScriptObject((Map)val);
            }
            if (json) {
                buff.append("'" + key + "':");
            } else {
                buff.append(key + ":");
            }
            if (val == null) {
                buff.append("null");
            } else if (val instanceof Float || val instanceof Long || val instanceof Integer || val instanceof StringBuffer) {
                buff.append(val.toString());
            } else if (val instanceof String && ((String)val).trim().startsWith("{") || ((String)val).trim().startsWith("[")) {
                buff.append(val.toString());
            } else {
                buff.append("'" + val.toString() + "'");
            }
            if (!it.hasNext()) continue;
            buff.append(",");
        }
        buff.append("}");
        return buff;
    }

    public static String resolvePath(String rootPath, String relativePath) throws WidgetConfigException {
        int numberOfDirUp;
        int relativePos;
        if (rootPath == null || relativePath.startsWith("/") || IOUtil.isExternalUri(relativePath)) {
            return relativePath;
        }
        int relativePathLen = relativePath.length();
        for (relativePos = 0; relativePos < relativePathLen && relativePath.indexOf("../", relativePos) == relativePos; relativePos += 3) {
        }
        boolean rootPathEndsWithSlash = rootPath.endsWith("/");
        if (numberOfDirUp > 0) {
            int positionOfSlash;
            int rootPos;
            int n = rootPos = rootPathEndsWithSlash ? rootPath.length() - 1 : rootPath.length();
            for (numberOfDirUp = relativePos > 0 ? relativePos / 3 : 0; (positionOfSlash = rootPath.lastIndexOf(47, rootPos)) >= 0 && numberOfDirUp > 0; --numberOfDirUp) {
                rootPos = positionOfSlash;
            }
            if (numberOfDirUp > 0) {
                throw new WidgetConfigException("unable to combine '" + rootPath + "' with relative path '" + relativePath + "'");
            }
            return rootPath.substring(0, rootPos) + '/' + relativePath.substring(relativePos);
        }
        return rootPathEndsWithSlash ? rootPath + relativePath : rootPath + '/' + relativePath;
    }

    public static boolean isExternalUri(String uri) {
        return uri.startsWith("http://") || uri.startsWith("https://");
    }
}

