/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.ServletContext;
import jmaki.runtime.WidgetResourceException;

public class ResourceManager {
    private ServletContext context;
    private HashMap webResources;
    private HashMap classPathResources;
    private boolean usecache;
    private String resoucesDir;
    private static final String CLASSPATHPREFIX = "/META-INF";

    public ResourceManager(ServletContext ctx, boolean usecache) {
        this.context = ctx;
        this.usecache = usecache;
        if (usecache) {
            this.webResources = new HashMap();
            this.classPathResources = new HashMap();
        }
        if ((this.resoucesDir = ctx.getInitParameter("jmaki-resources")) == null) {
            this.resoucesDir = "/resources";
        }
    }

    public boolean isWebAppResource(String resource) throws WidgetResourceException {
        return this.locateWebAppResource(resource) != null;
    }

    public URL locateWebAppResource(String resource) throws WidgetResourceException {
        if (this.usecache && this.webResources.containsKey(resource)) {
            return (URL)this.webResources.get(resource);
        }
        try {
            URL url = this.context.getResource(resource);
            if (this.usecache) {
                this.webResources.put(resource, url);
            }
            return url;
        }
        catch (MalformedURLException mue) {
            throw new WidgetResourceException("error locating resource: '" + resource + "'", mue);
        }
    }

    public boolean isClassPathResource(String resource) {
        return this.locateClassPathResource(resource) != null;
    }

    public URL locateClassPathResource(String resource) {
        if (this.usecache && this.classPathResources.containsKey(resource)) {
            return (URL)this.classPathResources.get(resource);
        }
        URL url = this.getClass().getResource(CLASSPATHPREFIX + resource);
        if (this.usecache) {
            this.classPathResources.put(resource, url);
        }
        return url;
    }

    public String getClassPathResourcePath() {
        return CLASSPATHPREFIX + this.getResourcesDir();
    }

    public String getWebResourcePath() {
        return this.getResourcesDir();
    }

    public String getResourcesDir() {
        return this.resoucesDir;
    }

    public String getWidgetDir(String widgettype) {
        return "/" + widgettype.replace('.', '/');
    }
}

