/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jmaki.runtime.AjaxException;
import jmaki.runtime.IOUtil;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.config.ApiKey;
import jmaki.runtime.config.ApiKeyMap;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.ConfigImpl;
import jmaki.runtime.config.Type;
import jmaki.runtime.config.WidgetConfig;
import jmaki.runtime.config.WidgetConfigException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalConfig {
    private static final String GLOBALCONFIG = "/config.json";
    private static final String WIDGETCONFIG = "/widget.json";
    private HashMap globalTypes = null;
    private ApiKeyMap globalApiKeys = null;
    private HashMap widgetConfigs = new HashMap();
    private ResourceManager resourceManager;
    public static final Iterator NULLITERATOR = new Iterator(){

        public Object next() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return false;
        }

        public void remove() throws IllegalStateException {
            throw new IllegalStateException("next has not been called yet");
        }
    };
    private boolean isGlobalConfigWebAppResource = false;

    public boolean isGlobalConfigWebAppResource() {
        return this.isGlobalConfigWebAppResource;
    }

    public GlobalConfig(ResourceManager resourceManager) throws AjaxException {
        this.resourceManager = resourceManager;
        if (resourceManager.isClassPathResource(GLOBALCONFIG)) {
            this.loadGlobalConfig(resourceManager.locateClassPathResource(GLOBALCONFIG));
        }
        if (resourceManager.isWebAppResource(GLOBALCONFIG)) {
            this.loadGlobalConfig(resourceManager.locateWebAppResource(GLOBALCONFIG));
            this.isGlobalConfigWebAppResource = true;
        }
    }

    public Config getConfig(String widgetname, String location) throws AjaxException {
        int positionOfDot;
        WidgetConfig widgetConfig = null;
        Type type = null;
        if (location != null && (widgetConfig = (WidgetConfig)this.widgetConfigs.get(location)) == null) {
            widgetConfig = this.loadWidgetConfig(widgetname, location);
            this.widgetConfigs.put(location, widgetConfig);
        }
        if ((type = widgetConfig.getType()) == null && this.globalTypes != null && (type = (Type)this.globalTypes.get(widgetname)) == null && (positionOfDot = widgetname.indexOf(46)) < 1) {
            type = (Type)this.globalTypes.get(widgetname.substring(0, positionOfDot));
        }
        return new ConfigImpl(type, this.globalApiKeys, widgetConfig.getApiKeyMap());
    }

    public void discard() {
        if (this.globalApiKeys != null) {
            this.globalApiKeys.discard();
            this.globalApiKeys = null;
        }
        if (this.globalTypes != null) {
            Iterator globalTypesIterator = this.globalTypes.entrySet().iterator();
            while (globalTypesIterator.hasNext()) {
                ((Type)globalTypesIterator.next().getValue()).discard();
            }
            this.globalTypes.clear();
            this.globalTypes = null;
        }
        if (this.widgetConfigs != null) {
            Iterator widgetConfigsIterator = this.widgetConfigs.entrySet().iterator();
            while (widgetConfigsIterator.hasNext()) {
                ((WidgetConfig)widgetConfigsIterator.next().getValue()).discard();
            }
            this.widgetConfigs.clear();
            this.widgetConfigs = null;
        }
    }

    private synchronized void loadGlobalConfig(URL url) throws AjaxException {
        InputStream is = null;
        try {
            JSONObject jAll;
            is = url.openConnection().getInputStream();
            if (is != null && (jAll = IOUtil.loadJSONObject(is)).has("config")) {
                String keytype;
                int l;
                JSONObject dConfig = jAll.getJSONObject("config");
                if (dConfig.has("types")) {
                    JSONArray typesArray = dConfig.getJSONArray("types");
                    for (l = 0; l < typesArray.length(); ++l) {
                        JSONObject jType = typesArray.getJSONObject(l);
                        keytype = jType.getString("id");
                        if (this.globalTypes == null) {
                            this.globalTypes = new HashMap();
                        }
                        this.globalTypes.put(keytype, this.loadType(null, jType));
                    }
                }
                if (dConfig.has("apikeys")) {
                    JSONArray apikeyArray = dConfig.getJSONArray("apikeys");
                    for (l = 0; l < apikeyArray.length(); ++l) {
                        List keyList;
                        JSONObject jApiKeys = apikeyArray.getJSONObject(l);
                        keytype = jApiKeys.getString("id");
                        if (this.globalApiKeys == null) {
                            this.globalApiKeys = new ApiKeyMap();
                        }
                        if ((keyList = this.loadApiKeys(jApiKeys, (List)this.globalApiKeys.get(keytype))) == null || this.globalApiKeys.containsKey(keytype)) continue;
                        this.globalApiKeys.put(keytype, keyList);
                    }
                }
            }
        }
        catch (JSONException ex) {
            throw new WidgetConfigException("error parsing 'config.json' from location: '" + url + "': " + ex.getMessage(), ex);
        }
        catch (IOException ioe) {
            throw new WidgetConfigException("error loading 'config.json' from location: '" + url + "': " + ioe.getMessage(), ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new WidgetConfigException("error closing inputstream for url: '" + url + "'", ioe);
                }
            }
        }
    }

    private synchronized WidgetConfig loadWidgetConfig(String widgetname, String location) throws AjaxException {
        URL url = null;
        WidgetConfig widgetConfig = new WidgetConfig();
        String widgetPath = location + WIDGETCONFIG;
        if (this.resourceManager.isWebAppResource(widgetPath)) {
            url = this.resourceManager.locateWebAppResource(widgetPath);
        } else if (this.resourceManager.isClassPathResource(widgetPath)) {
            url = this.resourceManager.locateClassPathResource(widgetPath);
        }
        InputStream is = null;
        try {
            JSONObject jAll;
            if (url != null) {
                is = url.openConnection().getInputStream();
            }
            if (is != null && (jAll = IOUtil.loadJSONObject(is)).has("config")) {
                JSONArray apikeyArray;
                JSONObject dConfig = jAll.getJSONObject("config");
                if (dConfig.has("type")) {
                    JSONObject jType = dConfig.getJSONObject("type");
                    int positionOfDot = widgetname.indexOf(46);
                    String widgettype = positionOfDot > 0 ? widgetname.substring(0, positionOfDot) : widgetname;
                    String keytype = jType.getString("id");
                    if (keytype.equals(widgetname) || keytype.equals(widgettype)) {
                        widgetConfig.setType(this.loadType(location, jType));
                    } else {
                        throw new WidgetConfigException("unexpected element 'id=" + keytype + "' in widget.json for '" + widgetname + "'");
                    }
                }
                if (dConfig.has("apikeys") && (apikeyArray = dConfig.getJSONArray("apikeys")).length() > 0) {
                    ApiKeyMap apiKeys = new ApiKeyMap();
                    for (int l = 0; l < apikeyArray.length(); ++l) {
                        String keytype;
                        JSONObject jApiKeys = apikeyArray.getJSONObject(l);
                        List keyList = this.loadApiKeys(jApiKeys, (List)apiKeys.get(keytype = jApiKeys.getString("id")));
                        if (keyList == null || apiKeys.containsKey(keytype)) continue;
                        apiKeys.put(keytype, keyList);
                    }
                    widgetConfig.setApiKeys(apiKeys);
                }
            }
        }
        catch (JSONException ex) {
            throw new WidgetConfigException("error parsing 'widget.json' from location: '" + url + "': " + ex.getMessage(), ex);
        }
        catch (IOException ioe) {
            throw new WidgetConfigException("error loading 'widget.json' from location: '" + url + "': " + ioe.getMessage(), ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new WidgetConfigException("error closing inputstream for url: '" + url + "'", ioe);
                }
            }
        }
        return widgetConfig;
    }

    private Type loadType(String currentDir, JSONObject jType) throws JSONException, WidgetConfigException {
        String s;
        int il;
        JSONArray nA;
        Type type = new Type();
        if (jType.has("styles")) {
            nA = jType.getJSONArray("styles");
            for (il = 0; il < nA.length(); ++il) {
                s = nA.getString(il);
                if (type.getStyles() == null) {
                    type.setStyles(new ArrayList());
                }
                type.getStyles().add(IOUtil.resolvePath(currentDir, s));
            }
        }
        if (jType.has("libs")) {
            nA = jType.getJSONArray("libs");
            for (il = 0; il < nA.length(); ++il) {
                s = nA.getString(il);
                if (type.getLibs() == null) {
                    type.setLibs(new ArrayList());
                }
                type.getLibs().add(IOUtil.resolvePath(currentDir, s));
            }
        }
        if (jType.has("preload")) {
            type.setPreLoad(jType.getString("preload"));
        }
        if (jType.has("postload")) {
            type.setPostLoad(jType.getString("postload"));
        }
        if (jType.has("apikey")) {
            type.setApiKeyType(jType.getString("apikey"));
        }
        return type;
    }

    private List loadApiKeys(JSONObject jApiKeys, List keyList) throws JSONException {
        JSONArray keys = jApiKeys.getJSONArray("keys");
        int keyListLen = keys.length();
        if (keyListLen > 0) {
            if (keyList == null) {
                keyList = new ArrayList<ApiKey>();
            }
            for (int k = 0; k < keyListLen; ++k) {
                JSONObject apiKey = keys.getJSONObject(k);
                String targeturl = apiKey.getString("url");
                if (targeturl.endsWith("/")) {
                    targeturl = targeturl.substring(0, targeturl.length() - 1);
                }
                keyList.add(new ApiKey(targeturl, apiKey.getString("key")));
            }
        }
        return keyList;
    }
}

