/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.arrivals;

import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.DynamicThread;
import com.blazemeter.jmeter.threads.arrivals.ArrivalsThreadStarter;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.ThreadCountsAccessor;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrivalsThreadGroup
extends AbstractDynamicThreadGroup {
    public static final String CONCURRENCY_LIMIT = "ConcurrencyLimit";
    public static final String ARRIVALS_LIMIT = "ArrivalsLimit";
    private static final Logger log = LoggerFactory.getLogger(ArrivalsThreadGroup.class);
    protected final AtomicLong arrivalsCount = new AtomicLong();
    protected final AtomicLong completionsCount = new AtomicLong();
    protected AtomicLong abandonsCount = new AtomicLong();
    protected final Set<DynamicThread> poolThreads = Collections.newSetFromMap(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree testTree, StandardJMeterEngine engine) {
        super.start(groupIndex, listenerNotifier, testTree, engine);
        ArrivalsThreadGroup arrivalsThreadGroup = this;
        synchronized (arrivalsThreadGroup) {
            try {
                ((Object)((Object)this)).wait();
                log.info("Got first arrival");
            }
            catch (InterruptedException e) {
                log.warn("Interrupted start", (Throwable)e);
            }
        }
    }

    public int getNumThreads() {
        return this.threads.size();
    }

    @Override
    public void addThread(DynamicThread threadWorker) {
        super.addThread(threadWorker);
        JMeterContextService.addTotalThreads((int)1);
    }

    @Override
    protected Thread getThreadStarter(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree testTree, StandardJMeterEngine engine) {
        return new ArrivalsThreadStarter(groupIndex, listenerNotifier, testTree, engine, this);
    }

    @Override
    public void stop() {
        super.stop();
        for (DynamicThread thread : this.poolThreads) {
            thread.interruptOSThread();
        }
    }

    @Override
    public void tellThreadsToStop() {
        super.tellThreadsToStop();
        for (DynamicThread thread : this.poolThreads) {
            this.stopThread(thread.getThreadName(), true);
        }
    }

    @Override
    public boolean verifyThreadsStopped() {
        boolean parent = super.verifyThreadsStopped();
        log.info("Verify shutdown thread counts: " + this.threads.size() + "/" + this.poolThreads.size());
        return parent && this.poolThreads.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean movedToPool(DynamicThread thread) {
        this.threads.remove((Object)thread);
        if (thread.isStopping()) {
            log.debug("Did not move into pool, because thread is stopping: " + (Object)((Object)thread));
            return false;
        }
        this.poolThreads.add(thread);
        log.debug("Moved thread to pool: " + (Object)((Object)thread) + ", pool size: " + this.poolThreads.size());
        ThreadCountsAccessor.decrNumberOfThreads();
        DynamicThread dynamicThread = thread;
        synchronized (dynamicThread) {
            try {
                ((Object)((Object)thread)).wait();
            }
            catch (InterruptedException e) {
                log.debug("Interrupted", (Throwable)e);
            }
        }
        ThreadCountsAccessor.incrNumberOfThreads();
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean releasedPoolThread() {
        if (this.poolThreads.isEmpty()) {
            return false;
        }
        DynamicThread thread = this.poolThreads.toArray(new DynamicThread[this.poolThreads.size()])[0];
        this.poolThreads.remove((Object)thread);
        this.threads.add(thread);
        log.debug("Releasing pool thread: " + (Object)((Object)thread) + ", pool size: " + this.poolThreads.size());
        DynamicThread dynamicThread = thread;
        synchronized (dynamicThread) {
            ((Object)((Object)thread)).notify();
        }
        return true;
    }

    @Override
    public boolean isLimitReached() {
        long limit;
        try {
            limit = Long.parseLong(this.getArrivalsLimit());
        }
        catch (NumberFormatException e) {
            log.error("Invalid arrivals limit, defaulting to 0");
            limit = 0L;
        }
        return limit > 0L && this.arrivalsCount.longValue() >= limit;
    }

    public synchronized void arrivalFact(JMeterThread thread, long arrivalID) {
        this.arrivalsCount.incrementAndGet();
        ((Object)((Object)this)).notifyAll();
        this.saveLogRecord("ARRIVAL", thread.getThreadName(), thread.getThreadNum() + "." + arrivalID);
    }

    public void completionFact(JMeterThread thread, long arrivalID) {
        this.completionsCount.incrementAndGet();
        this.saveLogRecord("COMPLETION", thread.getThreadName(), thread.getThreadNum() + "." + arrivalID);
    }

    public void abandonFact(JMeterThread thread, long arrivalID) {
        this.abandonsCount.incrementAndGet();
        this.saveLogRecord("ABANDONMENT", thread.getThreadName(), thread.getThreadNum() + "." + arrivalID);
    }

    public boolean canCreateMoreThreads() {
        try {
            long limit = Long.parseLong(this.getConcurrencyLimit());
            return limit <= 0L || (long)this.threads.size() < limit;
        }
        catch (NumberFormatException e) {
            log.debug("Invalid concurrency limit, defaulting to 0");
            return true;
        }
    }

    public void setConcurrencyLimit(String value) {
        this.setProperty(CONCURRENCY_LIMIT, value);
    }

    public String getConcurrencyLimit() {
        return this.getPropertyAsString(CONCURRENCY_LIMIT, "");
    }

    public void setArrivalsLimit(String value) {
        this.setProperty(ARRIVALS_LIMIT, value);
    }

    public String getArrivalsLimit() {
        return this.getPropertyAsString(ARRIVALS_LIMIT, "0");
    }

    @Override
    public void testEnded(String s) {
        this.releaseAllPoolThreads();
        super.testEnded(s);
        log.info("Done " + this.arrivalsCount.longValue() + " arrivals, " + this.completionsCount.longValue() + " completions, " + this.abandonsCount.longValue() + " abandonments");
        log.debug("Pool size: " + this.poolThreads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllPoolThreads() {
        Iterator<DynamicThread> iterator = this.poolThreads.iterator();
        while (iterator.hasNext()) {
            DynamicThread thread;
            DynamicThread dynamicThread = thread = iterator.next();
            synchronized (dynamicThread) {
                thread.interrupt();
                thread.interruptOSThread();
                ((Object)((Object)thread)).notify();
            }
        }
    }
}

