/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics;

import com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics.JobLayer;
import java.io.IOException;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskReport;

public class TaskLayer
extends JobLayer {
    public String getTaskLevelCountersByJobId(String jobTracker, String jobId) throws IOException {
        Counters counter;
        StringBuilder taskCounters = new StringBuilder();
        JobID id = this.convertToJobId(jobId);
        JobClient client = this.prepareJobClient(jobTracker);
        RunningJob job = client.getJob(id);
        TaskReport[] mapTaskReports = client.getMapTaskReports(id);
        TaskReport[] reduceTaskReports = client.getReduceTaskReports(id);
        taskCounters.append("<job id='" + jobId + "' name='" + job.getJobName() + "'>\n");
        taskCounters.append(" <mapTasks>\n");
        for (TaskReport mapTaskReport : mapTaskReports) {
            taskCounters.append("  <task id='" + mapTaskReport.getTaskID().toString() + "'\n");
            taskCounters.append("   <counters>\n");
            counter = mapTaskReport.getCounters();
            for (Counters.Group group : counter) {
                for (Counters.Counter c : group) {
                    taskCounters.append("    <counter name='" + c.getDisplayName() + "' value='" + c.getValue() + "'>\n");
                }
            }
            taskCounters.append("   </counters>\n");
            taskCounters.append("  </task>\n");
        }
        taskCounters.append(" </mapTasks>\n");
        taskCounters.append(" <reduceTasks>\n");
        for (TaskReport reduceTaskReport : reduceTaskReports) {
            taskCounters.append("  <task id='" + reduceTaskReport.getTaskID().toString() + "'\n");
            taskCounters.append("   <counters>\n");
            counter = reduceTaskReport.getCounters();
            for (Counters.Group group : counter) {
                for (Counters.Counter c : group) {
                    taskCounters.append("    <counter name='" + c.getDisplayName() + "' value='" + c.getValue() + "'>\n");
                }
            }
            taskCounters.append("   </counters>\n");
            taskCounters.append("  </task>\n");
        }
        taskCounters.append(" </reduceTasks>\n");
        taskCounters.append("</job>");
        return taskCounters.toString();
    }

    public String getTaskStatisticsByJobId(String jobTracker, String jobId) throws IOException {
        String taskProgress;
        double progress;
        StringBuilder taskStatistics = new StringBuilder();
        long taskDuration = 0L;
        String duration = "";
        JobID id = this.convertToJobId(jobId);
        JobClient client = this.prepareJobClient(jobTracker);
        RunningJob job = client.getJob(id);
        TaskReport[] mapTaskReports = client.getMapTaskReports(id);
        TaskReport[] reduceTaskReports = client.getReduceTaskReports(id);
        taskStatistics.append("<job id='" + jobId + "' name='" + job.getJobName() + "'>\n");
        taskStatistics.append(" <mapTasks>\n");
        for (TaskReport mapTaskReport : mapTaskReports) {
            taskDuration = mapTaskReport.getFinishTime() - mapTaskReport.getStartTime();
            duration = taskDuration < 0L ? "N/A" : String.valueOf(taskDuration);
            progress = mapTaskReport.getProgress() * 100.0f;
            taskProgress = Double.toString(progress) + "%";
            taskStatistics.append("  <task id='" + mapTaskReport.getTaskID().toString() + "'\n");
            taskStatistics.append("   <progress>" + taskProgress + "</progress>\n");
            taskStatistics.append("   <duration>" + duration + "</duration>\n");
            taskStatistics.append("   <status>" + mapTaskReport.getCurrentStatus().toString() + "</status>\n");
            taskStatistics.append("  </task>\n");
        }
        taskStatistics.append(" </mapTasks>\n");
        taskStatistics.append(" <reduceTasks>\n");
        for (TaskReport reduceTaskReport : reduceTaskReports) {
            taskDuration = reduceTaskReport.getFinishTime() - reduceTaskReport.getStartTime();
            duration = taskDuration < 0L ? "N/A" : String.valueOf(taskDuration);
            progress = reduceTaskReport.getProgress() * 100.0f;
            taskProgress = Double.toString(progress) + "%";
            taskStatistics.append("  <task id='" + reduceTaskReport.getTaskID().toString() + "'\n");
            taskStatistics.append("   <progress>" + taskProgress + "</progress>\n");
            taskStatistics.append("   <duration>" + duration + "</duration>\n");
            taskStatistics.append("   <status>" + reduceTaskReport.getCurrentStatus().toString() + "</status>\n");
            taskStatistics.append("  </task>\n");
        }
        taskStatistics.append(" </reduceTasks>\n");
        taskStatistics.append("</job>");
        return taskStatistics.toString();
    }
}

