/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.samplers.gui;

import com.atlantbh.jmeter.plugins.hbasecomponents.samplers.HBaseRowkeySampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class HBaseRowKeySamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = -7273634183896280753L;
    private JLabeledTextField connTF;
    private JLabeledTextField tableTF;
    private JLabeledTextField rowKeyTF;
    private JCheckBox emitVarsCB;
    private JCheckBox latestTimestampRows;

    public HBaseRowKeySamplerGui() {
        this.init();
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout(0, 10));
        VerticalPanel vertPanel = new VerticalPanel();
        vertPanel.add(this.makeTitlePanel());
        this.add((Component)vertPanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.connTF = this.createTF("Connection name");
        mainPanel.add((Component)this.connTF);
        this.tableTF = this.createTF("Table");
        mainPanel.add((Component)this.tableTF);
        this.rowKeyTF = this.createTF("RowKey");
        mainPanel.add((Component)this.rowKeyTF);
        this.emitVarsCB = new JCheckBox("Create variable for each row");
        this.latestTimestampRows = new JCheckBox("Retrieve most recent record");
        mainPanel.add(this.emitVarsCB);
        mainPanel.add(this.latestTimestampRows);
        this.add(mainPanel, "Center");
    }

    public String getStaticLabel() {
        return "HBase Rowkey Sampler";
    }

    public String getLabelResource() {
        return "hbase_rowkey_sampler";
    }

    public TestElement createTestElement() {
        HBaseRowkeySampler sampler = new HBaseRowkeySampler();
        this.configureTestElement((TestElement)sampler);
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        HBaseRowkeySampler sampler = (HBaseRowkeySampler)te;
        sampler.setConnectionName(this.connTF.getText());
        sampler.sethBaseTable(this.tableTF.getText());
        sampler.setRowKey(this.rowKeyTF.getText());
        sampler.setOmitVars(this.emitVarsCB.isSelected());
        sampler.setLatestTimestampRows(this.latestTimestampRows.isSelected());
        super.configureTestElement((TestElement)sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        HBaseRowkeySampler sampler = (HBaseRowkeySampler)el;
        this.connTF.setText(sampler.getConnectionName());
        this.tableTF.setText(sampler.gethBaseTable());
        this.rowKeyTF.setText(sampler.getRowKey());
        this.emitVarsCB.setSelected(sampler.getOmitVars());
        this.latestTimestampRows.setSelected(sampler.getLatestTimestampRows());
    }

    public void clearGui() {
        super.clearGui();
        this.tableTF.setText("");
        this.rowKeyTF.setText("");
        this.emitVarsCB.setSelected(false);
        this.latestTimestampRows.setSelected(false);
    }

    private JLabeledTextField createTF(String name) {
        JLabeledTextField tf = new JLabeledTextField(name);
        tf.setMaximumSize(new Dimension(10000, 26));
        tf.setBorder((Border)new EmptyBorder(3, 0, 3, 0));
        tf.getComponents()[0].setPreferredSize(new Dimension(120, tf.getComponents()[0].getPreferredSize().height));
        return tf;
    }
}

