/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.samplers.gui;

import com.atlantbh.jmeter.plugins.hbasecomponents.samplers.HBaseScanSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class HBaseScanSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = -4115128550923988380L;
    private JLabeledTextField connTF;
    private JLabeledTextField tableTF;
    private JLabeledTextField startRowKeyTF;
    private JLabeledTextField endRowKeyTF;
    private JLabeledTextField recordCountTF;
    private JLabeledTextArea filtersTA;
    private JCheckBox emitVarsCB;
    private JCheckBox latestTimestampRows;

    public HBaseScanSamplerGui() {
        this.init();
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout(0, 10));
        VerticalPanel vertPanel = new VerticalPanel();
        vertPanel.add(this.makeTitlePanel());
        this.add((Component)vertPanel, "North");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.connTF = this.createTF("Connection name");
        mainPanel.add((Component)this.connTF);
        this.tableTF = this.createTF("Table");
        mainPanel.add((Component)this.tableTF);
        this.startRowKeyTF = this.createTF("Start rowKey");
        mainPanel.add((Component)this.startRowKeyTF);
        this.endRowKeyTF = this.createTF("End rowKey");
        mainPanel.add((Component)this.endRowKeyTF);
        this.recordCountTF = this.createTF("Limit");
        mainPanel.add((Component)this.recordCountTF);
        this.filtersTA = new JLabeledTextArea("Filters");
        mainPanel.add((Component)this.filtersTA);
        this.emitVarsCB = new JCheckBox("Create variable for each row");
        this.latestTimestampRows = new JCheckBox("Retrieve most recent record");
        mainPanel.add(this.emitVarsCB);
        mainPanel.add(this.latestTimestampRows);
        this.add(mainPanel, "Center");
    }

    public String getStaticLabel() {
        return "HBase Scan Sampler";
    }

    public String getLabelResource() {
        return "hbase_scan_sampler";
    }

    public TestElement createTestElement() {
        HBaseScanSampler sampler = new HBaseScanSampler();
        this.configureTestElement((TestElement)sampler);
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        HBaseScanSampler sampler = (HBaseScanSampler)te;
        sampler.setConnectionName(this.connTF.getText());
        sampler.setTableName(this.tableTF.getText());
        sampler.setStartKey(this.startRowKeyTF.getText());
        sampler.setEndKey(this.endRowKeyTF.getText());
        sampler.setLimit(this.recordCountTF.getText());
        sampler.setFilter(this.filtersTA.getText());
        sampler.setOmitVars(this.emitVarsCB.isSelected());
        sampler.setLatestTimestampRows(this.latestTimestampRows.isSelected());
        super.configureTestElement((TestElement)sampler);
    }

    public void configure(TestElement el) {
        super.configure(el);
        HBaseScanSampler sampler = (HBaseScanSampler)el;
        this.connTF.setText(sampler.getConnectionName());
        this.tableTF.setText(sampler.getTableName());
        this.startRowKeyTF.setText(sampler.getStartKey());
        this.endRowKeyTF.setText(sampler.getEndKey());
        this.recordCountTF.setText(sampler.getLimit());
        this.filtersTA.setText(sampler.getFilter());
        this.emitVarsCB.setSelected(sampler.getOmitVars());
        this.latestTimestampRows.setSelected(sampler.getLatestTimestampRows());
    }

    public void clearGui() {
        super.clearGui();
        this.connTF.setText("");
        this.tableTF.setText("");
        this.startRowKeyTF.setText("");
        this.endRowKeyTF.setText("");
        this.recordCountTF.setText("5");
        this.filtersTA.setText("");
        this.emitVarsCB.setSelected(false);
        this.latestTimestampRows.setSelected(false);
    }

    private JLabeledTextField createTF(String name) {
        JLabeledTextField tf = new JLabeledTextField(name);
        tf.setMaximumSize(new Dimension(10000, 26));
        tf.setBorder((Border)new EmptyBorder(3, 0, 3, 0));
        tf.getComponents()[0].setPreferredSize(new Dimension(180, tf.getComponents()[0].getPreferredSize().height));
        return tf;
    }
}

