/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.utils;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.jmeter.threads.JMeterVariables;

public class Row2XML {
    public static String row2xmlstring(Result result, JMeterVariables vars, int index) throws UnsupportedEncodingException {
        StringBuilder xml = new StringBuilder();
        NavigableMap map = result.getNoVersionMap();
        xml.append("<row>\n");
        for (byte[] fam : map.keySet()) {
            String family = new String(fam);
            xml.append(" <family name=\"" + family + "\">\n");
            NavigableMap famMap = result.getFamilyMap(fam);
            for (Map.Entry e : famMap.entrySet()) {
                String key = new String((byte[])e.getKey(), "UTF-8");
                String value = new String((byte[])e.getValue(), "UTF-8");
                xml.append("  <column name=\"" + key + "\" value=\"" + value + "\"/>\n");
                if (vars == null) continue;
                if (index != 0) {
                    vars.put(family + ":" + key + "_" + index, value);
                    continue;
                }
                vars.put(family + ":" + key, value);
            }
            xml.append(" </family>\n");
        }
        xml.append("</row>\n");
        return xml.toString();
    }

    public static String row2xmlStringLatest(Result result, JMeterVariables vars, int index) {
        StringBuilder xml = new StringBuilder();
        NavigableMap map = result.getMap();
        long maxts = Long.MIN_VALUE;
        for (KeyValue kv : result.list()) {
            if (maxts >= kv.getTimestamp()) continue;
            maxts = kv.getTimestamp();
        }
        xml.append("<row>\n");
        for (byte[] fam : map.keySet()) {
            String family = new String(fam);
            xml.append(" <family name=\"" + family + "\">\n");
            NavigableMap qualifierMap = (NavigableMap)map.get(fam);
            for (Map.Entry e : qualifierMap.entrySet()) {
                NavigableMap valueMap = (NavigableMap)e.getValue();
                byte[] value = (byte[])valueMap.get(maxts);
                if (value == null) continue;
                String key = new String((byte[])e.getKey());
                String strValue = new String(value);
                xml.append("  <column name=\"" + key + "\" value=\"" + strValue.toString() + "\"/>\n");
                if (vars == null) continue;
                if (index != 0) {
                    vars.put(family + ":" + key + "_" + index, strValue.toString());
                    continue;
                }
                vars.put(family + ":" + key, strValue.toString());
            }
            xml.append(" </family>\n");
        }
        xml.append("</row>\n");
        return xml.toString();
    }
}

