/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.Serializable;
import java.text.ParseException;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;

public class JSONPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final long serialVersionUID = 1L;
    private static final String JSONPATH = "JSON_PATH";
    private static final String EXPECTEDVALUE = "EXPECTED_VALUE";
    private static final String JSONVALIDATION = "JSONVALIDATION";

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getExpectedValue() {
        return this.getPropertyAsString(EXPECTEDVALUE);
    }

    public void setExpectedValue(String expectedValue) {
        this.setProperty(EXPECTEDVALUE, expectedValue);
    }

    public void setJsonValidationBool(boolean jsonValidation) {
        this.setProperty(JSONVALIDATION, jsonValidation);
    }

    public boolean isJsonValidationBool() {
        return this.getPropertyAsBoolean(JSONVALIDATION);
    }

    public boolean checkJSONPathWithoutValidation(String jsonString, String jsonPath) throws Exception {
        String jsonPathResult = "";
        jsonPathResult = JsonPath.read((String)jsonString, (String)jsonPath, (Filter[])new Filter[0]).toString();
        if ("".equalsIgnoreCase(jsonPath)) {
            throw new Exception("JSON path is is empty!");
        }
        if ("".equalsIgnoreCase(jsonPathResult)) {
            throw new Exception("Incorrect JSON path");
        }
        return true;
    }

    public boolean checkJSONPathWithValidation(String jsonString, String jsonPath, String expectedValue) throws Exception {
        if ("".equalsIgnoreCase(jsonPath) || "".equalsIgnoreCase(expectedValue)) {
            throw new Exception("JSON path or expected value is empty!");
        }
        if (expectedValue.equalsIgnoreCase(JsonPath.read((String)jsonString, (String)jsonPath, (Filter[])new Filter[0]).toString())) {
            return true;
        }
        throw new Exception("Response doesn't contain expected value.");
    }

    public AssertionResult getResult(SampleResult samplerResult) {
        AssertionResult result = new AssertionResult(this.getName());
        byte[] responseData = samplerResult.getResponseData();
        if (responseData.length == 0) {
            return result.setResultForNull();
        }
        if (this.isJsonValidationBool()) {
            try {
                if (this.checkJSONPathWithValidation(new String(responseData), this.getJsonPath(), this.getExpectedValue())) {
                    result.setFailure(false);
                    result.setFailureMessage("");
                }
            }
            catch (ParseException e) {
                result.setFailure(true);
                result.setFailureMessage(e.getClass().toString() + " - " + e.getMessage());
            }
            catch (Exception e) {
                result.setFailure(true);
                result.setFailureMessage(e.getMessage());
            }
        }
        if (!this.isJsonValidationBool()) {
            try {
                if (this.checkJSONPathWithoutValidation(new String(responseData), this.getJsonPath())) {
                    result.setFailure(false);
                    result.setFailureMessage("");
                }
            }
            catch (ParseException e) {
                result.setFailure(true);
                result.setFailureMessage(e.getClass().toString() + " - " + e.getMessage());
            }
            catch (Exception e) {
                result.setFailure(true);
                result.setFailureMessage(e.getMessage());
            }
        }
        return result;
    }
}

