/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.oauth;

import com.atlantbh.jmeter.plugins.oauth.Parameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class OAuthGenerator {
    private static final String UTF_8 = "UTF-8";
    private static final String MAC_NAME = "HmacSHA1";
    private static final String MAC_VALUE = "HMAC-SHA1";
    private static final String VERSION_VALUE = "1.0";
    public static final String REALM = "realm";
    public static final String CONSUMER_KEY = "oauth_consumer_key";
    public static final String SIGNATURE = "oauth_signature";
    public static final String SIGNATURE_METHOD = "oauth_signature_method";
    public static final String TIMESTAMP = "oauth_timestamp";
    public static final String NONCE = "oauth_nonce";
    public static final String VERSION = "oauth_version";
    public static final String TOKEN = "oauth_token";
    private static final BASE64Encoder base64 = new BASE64Encoder();
    private static final Logger log = Logger.getLogger(OAuthGenerator.class.getName());
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private Mac mac;
    private List<Parameter> queryParameters;

    public static OAuthGenerator getInstance(String consumerKey, String consumerSecret) {
        try {
            return new OAuthGenerator(consumerKey, consumerSecret);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Initialization of OAuthGenerator has failed.", e);
            return null;
        }
    }

    public String getAuthorization(String url, String method) {
        if (url == null) {
            log.severe("The request url is null.");
            return null;
        }
        if (method == null) {
            log.severe("The request method is null.");
            return null;
        }
        String normalizedUrl = this.processUrl(url);
        if (normalizedUrl == null) {
            log.severe("The provided url was rejected.");
            return null;
        }
        String signature = this.getSignature(normalizedUrl, method);
        if (signature == null) {
            log.severe("Could not calculate signature for provided parameters.");
            return null;
        }
        return this.getHeaderValue(signature, normalizedUrl);
    }

    private OAuthGenerator(String consumerKey, String consumerSecret) {
        if (consumerKey == null || consumerSecret == null) {
            throw new IllegalArgumentException();
        }
        this.buildInitialParameterMap(consumerKey);
        this.mac = this.getMac(consumerSecret);
        if (this.mac == null) {
            throw new IllegalArgumentException("Could not initialize MAC with provided consumer secret.");
        }
    }

    private Mac getMac(String consumerSecret) {
        try {
            SecretKeySpec key = new SecretKeySpec((consumerSecret + '&').getBytes(UTF_8), MAC_NAME);
            Mac result = Mac.getInstance(MAC_NAME);
            result.init(key);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "This exception should never ocurr!", e);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, "This exception should never ocurr!", e);
        }
        catch (InvalidKeyException e) {
            log.log(Level.SEVERE, "The key used to initialize MAC algorithm is invalid.", e);
        }
        return null;
    }

    private String getSignature(String requestUrl, String method) {
        this.updateParameterMap();
        String sbs = method + '&' + Parameter.percentEncode(requestUrl) + '&' + Parameter.percentEncode(this.sortAndEncodeParameters());
        try {
            return base64.encode(this.mac.doFinal(sbs.getBytes(UTF_8))).trim();
        }
        catch (IllegalStateException e) {
            log.log(Level.SEVERE, "This exception should never ocurr!", e);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.SEVERE, "This exception should never ocurr!", e);
        }
        return null;
    }

    private String sortAndEncodeParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>(this.queryParameters);
        for (String key : this.parameterMap.keySet()) {
            params.add(new Parameter(key, this.parameterMap.get(key)));
        }
        Collections.sort(params);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean first = true;
        for (Parameter parameter : params) {
            if (first) {
                first = false;
            } else {
                out.write(38);
            }
            try {
                out.write(parameter.getKey().getBytes());
                out.write(61);
                out.write(Parameter.percentEncode(parameter.getValue()).getBytes());
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "This should never happen.", e);
            }
        }
        return new String(out.toByteArray());
    }

    private String processUrl(String requestUrl) {
        String path;
        int index;
        URI uri = null;
        try {
            uri = new URI(requestUrl);
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "The url " + requestUrl + " has invalid syntax.", e);
            return null;
        }
        this.processQueryParameters(uri.getQuery());
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        if ((scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443) && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    private void processQueryParameters(String decodedQuery) {
        this.queryParameters = new ArrayList<Parameter>();
        if (decodedQuery == null) {
            return;
        }
        for (String queryPart : decodedQuery.split("&")) {
            if (queryPart.contains("=")) {
                String[] split = queryPart.split("=");
                if (split.length == 2) {
                    this.queryParameters.add(new Parameter(split[0], split[1]));
                    continue;
                }
                this.queryParameters.add(new Parameter(split[0], ""));
                continue;
            }
            this.queryParameters.add(new Parameter(queryPart, ""));
        }
    }

    private String getHeaderValue(String signature, String realm) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ");
        sb.append(this.getHeaderElement(REALM, realm)).append(",");
        for (String key : this.parameterMap.keySet()) {
            String value = this.parameterMap.get(key);
            sb.append(this.getHeaderElement(key, value));
            sb.append(",");
        }
        sb.append(this.getHeaderElement(SIGNATURE, signature));
        return sb.toString();
    }

    private void buildInitialParameterMap(String consumerKey) {
        this.parameterMap.put(CONSUMER_KEY, consumerKey);
        this.parameterMap.put(SIGNATURE_METHOD, MAC_VALUE);
        this.parameterMap.put(VERSION, VERSION_VALUE);
    }

    private void updateParameterMap() {
        this.parameterMap.put(TIMESTAMP, Long.toString(System.currentTimeMillis() / 1000L));
        this.parameterMap.put(NONCE, Long.toString(System.nanoTime()));
    }

    private String getHeaderElement(String name, String value) {
        return Parameter.percentEncode(name) + "=\"" + Parameter.percentEncode(value) + "\"";
    }
}

