/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class Parameter
implements Comparable<Parameter>,
Map.Entry<String, String> {
    private final String key;
    private String value;
    private String compareKey;

    private void calculateCompareKey() {
        this.compareKey = Parameter.percentEncode(this.key) + ' ' + Parameter.percentEncode(this.value);
    }

    public Parameter(String key, String value) {
        this.key = key;
        this.value = value;
        this.calculateCompareKey();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        String result = this.value;
        this.value = value;
        this.calculateCompareKey();
        return result;
    }

    public String toString() {
        return this.getKey() + '=' + this.getValue();
    }

    @Override
    public int compareTo(Parameter other) {
        return this.compareKey.compareTo(other.compareKey);
    }

    public static String percentEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

