/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.config.LockFile;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LockFileGui
extends AbstractConfigGui {
    public static final String WIKIPAGE = "LockFile";
    public static Logger log = LoggingManager.getLoggerForClass();
    private JTextField tfFileName;
    private JTextField tfFileMask;

    public LockFileGui() {
        this.init();
        this.initFields();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Lock File Config");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement te) {
        log.debug("[Lockfile plugin] configure");
        super.configure(te);
        LockFile lf = (LockFile)te;
        this.tfFileName.setText(lf.getFilename());
        this.tfFileMask.setText(lf.getFilemask());
    }

    public TestElement createTestElement() {
        log.debug("[Lockfile plugin] createTestElement");
        LockFile lockFile = new LockFile();
        this.modifyTestElement((TestElement)lockFile);
        lockFile.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return lockFile;
    }

    public void modifyTestElement(TestElement te) {
        log.debug("[Lockfile plugin] modifyTestElement");
        this.configureTestElement(te);
        LockFile lf = (LockFile)te;
        lf.setFilename(this.tfFileName.getText());
        lf.setFilemask(this.tfFileMask.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.initFields();
    }

    private void init() {
        log.debug("[Lockfile plugin] init");
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(mainPanel, labelConstraints, 0, 0, new JLabel("Lock file name: ", 4));
        this.tfFileName = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 0, this.tfFileName);
        this.addToPanel(mainPanel, labelConstraints, 0, 1, new JLabel("Also check filemask: ", 4));
        this.tfFileMask = new JTextField(20);
        this.addToPanel(mainPanel, editConstraints, 1, 1, this.tfFileMask);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)mainPanel, "North");
        this.add(container, "Center");
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }

    private void initFields() {
        log.debug("[Lockfile plugin] initFields");
        this.tfFileName.setText("");
        this.tfFileMask.setText("");
    }
}

