/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.config.VariableFromCsvFileReader;

public class TestCsvFileAction
implements ActionListener {
    private final JTextField filename;
    private final JTextField prefix;
    private final JTextField separator;
    private final JTextArea infoArea;

    public TestCsvFileAction(JTextField fileName, JTextField prefix, JTextField separator, JTextArea infoArea) {
        this.filename = fileName;
        this.prefix = prefix;
        this.separator = separator;
        this.infoArea = infoArea;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.infoArea.setText("");
        this.infoArea.setForeground(Color.black);
        boolean noValues = true;
        String msgVars = "";
        int count = 0;
        File f = new File(this.filename.getText());
        if (!f.exists()) {
            this.reportError("File '" + this.filename.getText() + "' was not found...");
            return;
        }
        try {
            VariableFromCsvFileReader reader = new VariableFromCsvFileReader(this.filename.getText());
            Map<String, String> vars = reader.getDataAsMap(this.prefix.getText(), this.separator.getText());
            for (String var : vars.keySet()) {
                String value = vars.get(var);
                if (!"".equals(value)) {
                    noValues = false;
                }
                msgVars = msgVars + "${" + var + "} = " + vars.get(var) + "\n";
                ++count;
            }
        }
        catch (Exception ex) {
            this.reportError("Error processing file: " + ex.toString());
        }
        if (count == 0) {
            this.reportError("File parsed, but no variable found.");
        } else if (noValues) {
            this.reportOk("WARNING: File parsed, " + count + " variable" + (count > 1 ? "s" : "") + " found, but no variable have value!");
            this.reportOk(msgVars);
        } else {
            this.reportOk("File successfuly parsed, " + count + " variable" + (count > 1 ? "s" : "") + " found:");
            this.reportOk(msgVars);
        }
    }

    private void reportError(String msg) {
        this.infoArea.setText(this.infoArea.getText() + "Problem detected: " + msg + "\n");
        this.infoArea.setForeground(Color.red);
    }

    private void reportOk(String string) {
        this.infoArea.setText(this.infoArea.getText() + string + "\n");
    }
}

