/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class VariableFromCsvFileReader {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private File file;

    public VariableFromCsvFileReader(String csvFileName) {
        this.file = new File(csvFileName);
    }

    public Map<String, String> getDataAsMap(String prefix, String separator) {
        if (separator.isEmpty()) {
            throw new IllegalArgumentException("CSV separator cannot be empty");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.file));
                String line = reader.readLine();
                while (line != null) {
                    String[] lineValues = JOrphanUtils.split((String)line, (String)separator, (boolean)false);
                    switch (lineValues.length) {
                        case 1: {
                            log.warn("Less than 2 columns at line: " + line);
                            ret.put(prefix + lineValues[0], "");
                            break;
                        }
                        case 2: {
                            ret.put(prefix + lineValues[0], lineValues[1]);
                            break;
                        }
                        default: {
                            log.warn("Bad format for line: " + line);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException ex) {
                log.error("File not found: " + ex.getMessage());
            }
            catch (IOException ex) {
                log.error("Error while reading: " + ex.getMessage());
            }
        }
        return ret;
    }
}

