/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dbmon;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kg.apc.jmeter.dbmon.DbMonSampleGenerator;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DbMonSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String metricName;
    private String sql;
    private final Connection connection;
    private boolean sampleDeltaValue = true;
    private double oldValue = Double.NaN;

    public DbMonSampler(Connection conn, String name, boolean sampleDeltaValue, String sql) {
        this.metricName = name;
        this.connection = conn;
        this.sql = sql;
        this.sampleDeltaValue = sampleDeltaValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSamples(DbMonSampleGenerator collector) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery(this.sql);
            if (rs.next()) {
                double val = rs.getDouble(1);
                if (this.sampleDeltaValue) {
                    if (!Double.isNaN(this.oldValue)) {
                        collector.generateSample(val - this.oldValue, this.metricName);
                    }
                    this.oldValue = val;
                } else {
                    collector.generateSample(val, this.metricName);
                }
            }
            this.close(rs);
            this.close(stmt);
        }
        catch (SQLException ex) {
            try {
                log.error("Error executing query: " + this.sql, (Throwable)ex);
                this.close(rs);
                this.close(stmt);
            }
            catch (Throwable throwable) {
                this.close(rs);
                this.close(stmt);
                throw throwable;
            }
        }
    }

    private void close(ResultSet r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (SQLException ex) {
                log.warn("Failed to close resultset", (Throwable)ex);
            }
        }
    }

    private void close(Statement r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (SQLException ex) {
                log.warn("Failed to close statement", (Throwable)ex);
            }
        }
    }
}

