/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dcerpc;

import java.io.ByteArrayOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kg.apc.jmeter.dcerpc.BinaryUtils;
import kg.apc.jmeter.dcerpc.RPCMarshallingException;
import org.apache.jorphan.util.JOrphanUtils;

public class DCERPCMarshalling {
    private static final char MARSHAL_REGULAR = ' ';
    private static final char MARSHAL_LENGTH_PREFIXED = 'L';
    private static final char MARSHAL_NULL_TERMINATED = 'Z';
    private static final char MARSHAL_LENGTH_PREFIXED_NULL_TERMINATED = 'N';
    private static final char MARSHAL_DOUBLE_LENGTH_PREFIXED_NULL_TERMINATED = 'D';
    private static final char MARSHAL_QUARTER_LENGTH_PREFIXED = 'Q';
    private static final char MARSHAL_BPP_PREPARE_TRANS = 'P';
    private static final char MARSHAL_BPP_INVOKE_XML = 'X';
    private static final char MARSHAL_FIXED_LENGTH = 'F';
    private static final char MARSHAL_INTEGER = 'I';
    private static final char MARSHAL_DOUBLE = 'B';
    private static final char UNMARSHAL_INTEGERS = 'I';
    private static final char UNMARSHAL_STRING_PARTS = 'S';
    private static final char UNMARSHAL_SINGLE_XML = 'X';
    private static final char UNMARSHAL_NONE = 'N';
    private static final int DEFAULT_UNMARSHAL_STRING_LEN = 5;

    public static String unmarshalData(byte[] ba, String unmarshalOptions) throws RPCMarshallingException {
        int unmarshalMode = 78;
        String[] options = unmarshalOptions.split(":");
        if (options[0].length() == 1) {
            unmarshalMode = options[0].charAt(0);
        }
        switch (unmarshalMode) {
            case 73: {
                int limit;
                if (options.length < 2) {
                    limit = 0;
                } else {
                    limit = Integer.decode(options[1]);
                    if (limit < 1) {
                        throw new RPCMarshallingException("Invalid limit: " + unmarshalOptions);
                    }
                }
                return DCERPCMarshalling.unmarshalConvertIntegers(ba, limit);
            }
            case 83: {
                int len;
                if (options.length < 2) {
                    len = 5;
                } else {
                    len = Integer.decode(options[1]);
                    if (len < 1) {
                        throw new RPCMarshallingException("Invalid length: " + unmarshalOptions);
                    }
                }
                return DCERPCMarshalling.unmarshalConvertStringParts(ba, len);
            }
            case 88: {
                String convertedText = DCERPCMarshalling.unmarshalConvertStringParts(ba, 1);
                return convertedText;
            }
        }
        return JOrphanUtils.baToHexString((byte[])ba);
    }

    private static String unmarshalConvertStringParts(byte[] ba, int lengthThreshold) {
        StringBuffer result_buffer = new StringBuffer();
        StringBuffer binary_buffer = new StringBuffer();
        ByteArrayOutputStream text_buffer = new ByteArrayOutputStream();
        for (int i = 0; i < ba.length; ++i) {
            int j = ba[i] & 0xFF;
            if (DCERPCMarshalling.isNotVisibleChar(j)) {
                DCERPCMarshalling.addTextOrBinaryBuffer(result_buffer, text_buffer, binary_buffer, lengthThreshold);
                result_buffer.append(j < 16 ? "0" : "").append(Integer.toHexString(j));
                continue;
            }
            text_buffer.write(j);
            binary_buffer.append(j < 16 ? "0" : "").append(Integer.toHexString(j));
        }
        DCERPCMarshalling.addTextOrBinaryBuffer(result_buffer, text_buffer, binary_buffer, lengthThreshold);
        return result_buffer.toString();
    }

    private static void addTextOrBinaryBuffer(StringBuffer result_buffer, ByteArrayOutputStream text_buffer, StringBuffer binary_buffer, int lengthThreshold) {
        if (text_buffer.size() >= lengthThreshold) {
            result_buffer.append('{').append(text_buffer.toString()).append('}');
        } else {
            result_buffer.append(binary_buffer);
        }
        text_buffer.reset();
        binary_buffer.setLength(0);
    }

    private static boolean isNotVisibleChar(int j) {
        if (j == 9 || j == 10 || j == 13 || j > 191) {
            return false;
        }
        return j < 32 || j > 126 || j == 123 || j == 125;
    }

    public static String marshalData(String in_str) throws RPCMarshallingException {
        Pattern patt = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher m = patt.matcher(in_str);
        String replaceStr = null;
        while (m.find()) {
            char marshalMode = ' ';
            String txt = m.group(1);
            int pos = txt.indexOf(58);
            if (pos == 1) {
                marshalMode = txt.charAt(0);
                txt = txt.substring(2);
            }
            try {
                replaceStr = DCERPCMarshalling.marshalAs(marshalMode, txt);
            }
            catch (RPCMarshallingException e) {
                replaceStr = DCERPCMarshalling.marshalAs(' ', m.group(1));
            }
            in_str = in_str.replace("{" + m.group(1) + "}", replaceStr);
        }
        return in_str;
    }

    private static String marshalAs(char marshalMode, String txt) throws RPCMarshallingException {
        switch (marshalMode) {
            case 'L': {
                return BinaryUtils.intToHexString(txt.length()) + JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'Z': {
                txt = txt + '\u0000';
                return JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'F': {
                return DCERPCMarshalling.marshalAsFixedLength(txt);
            }
            case 'N': {
                txt = txt + '\u0000';
                return BinaryUtils.intToHexString(txt.length()) + JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'D': {
                txt = txt + '\u0000';
                return BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(0) + BinaryUtils.intToHexString(txt.length()) + JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'X': {
                return BinaryUtils.intToHexString(txt.length() + 1) + BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(txt.length()) + JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'Q': {
                return BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(txt.length()) + JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'P': {
                return BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(txt.length()) + BinaryUtils.intToHexString(200000) + BinaryUtils.intToHexString(txt.length()) + JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
            case 'I': {
                return BinaryUtils.intToHexString(Integer.valueOf(txt));
            }
            case 'B': {
                return BinaryUtils.doubleToHexString(Double.valueOf(txt));
            }
            case ' ': {
                return JOrphanUtils.baToHexString((byte[])txt.getBytes());
            }
        }
        throw new RPCMarshallingException("Unknown marshal mode: " + marshalMode);
    }

    private static String marshalAsFixedLength(String txt) throws RPCMarshallingException {
        int pos = txt.indexOf(58);
        if (pos < 1) {
            throw new RPCMarshallingException("Fixed length mode requires length specified as '12:data'");
        }
        int len = Integer.decode(txt.substring(0, pos));
        if (len < 1) {
            throw new RPCMarshallingException("Invalid fixed length: " + txt);
        }
        txt = txt.substring(pos + 1);
        for (int n = txt.length(); n < len; ++n) {
            txt = txt + '\u0000';
        }
        return JOrphanUtils.baToHexString((byte[])txt.getBytes());
    }

    private static String unmarshalConvertIntegers(byte[] ba, int limit) {
        int pos;
        String integers = "";
        int count = 0;
        for (pos = 0; pos < ba.length - ba.length % 4; pos += 4) {
            integers = integers + Integer.toString(BinaryUtils.fourBytesToIntVal(ba[pos], ba[pos + 1], ba[pos + 2], ba[pos + 3])) + ",";
            if (limit <= 0 || ++count < limit) continue;
        }
        byte[] tail = new byte[ba.length - pos];
        System.arraycopy(ba, pos, tail, 0, tail.length);
        System.err.println(tail);
        return (integers.length() > 0 ? "{" + integers + "}" : "") + JOrphanUtils.baToHexString((byte[])tail);
    }
}

