/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dcerpc;

import java.util.Iterator;
import kg.apc.jmeter.dcerpc.DCERPCMarshalling;
import kg.apc.jmeter.dcerpc.RPCBindRequest;
import kg.apc.jmeter.dcerpc.RPCCallRequest;
import kg.apc.jmeter.dcerpc.RPCMarshallingException;
import kg.apc.jmeter.dcerpc.RPCPacket;
import org.apache.jmeter.protocol.tcp.sampler.BinaryTCPClientImpl;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class DCERPCSamplerUtils {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static short getOpNum(String paramStr) {
        short opNum;
        try {
            opNum = Short.parseShort(paramStr);
        }
        catch (NumberFormatException e) {
            opNum = Short.MAX_VALUE;
            int report = JMeterContextService.getContext().getThreadNum();
            log.error(Integer.toString(report) + " Wrong OpNum supplied: " + paramStr + "=", (Throwable)e);
            JMeterVariables vars = JMeterContextService.getContext().getVariables();
            Iterator it = vars.getIterator();
            while (it.hasNext()) {
                log.info(it.next().toString());
            }
        }
        return opNum;
    }

    public static RPCPacket[] getPacketsArray(byte[] stubDataByteArray, int callID, short opNum) {
        int chunkLenLimit = 5816;
        int numPackets = (int)Math.ceil((double)stubDataByteArray.length / 5816.0);
        if (numPackets < 1) {
            throw new IllegalArgumentException("StubData resulted to invalid packets quantity: " + Integer.toString(numPackets) + "[" + Integer.toString(stubDataByteArray.length) + "/" + Integer.toString(5816) + "]");
        }
        RPCPacket[] result = new RPCCallRequest[numPackets];
        for (int packetNum = 0; packetNum < numPackets; ++packetNum) {
            byte packetFlags = DCERPCSamplerUtils.getPacketFlags(packetNum, numPackets);
            int chunkLen = packetNum == numPackets - 1 ? stubDataByteArray.length % 5816 : 5816;
            byte[] stubDataChunk = new byte[chunkLen];
            System.arraycopy(stubDataByteArray, packetNum * 5816, stubDataChunk, 0, chunkLen);
            result[packetNum] = new RPCCallRequest(callID, opNum, stubDataChunk, packetFlags);
        }
        return result;
    }

    public static byte getPacketFlags(int packetNum, int numPackets) {
        byte packetFlags = 0;
        if (packetNum == 0) {
            packetFlags = (byte)(packetFlags | 1);
        }
        if (packetNum == numPackets - 1) {
            packetFlags = (byte)(packetFlags | 2);
        }
        return packetFlags;
    }

    public static String getStubDataHex(String joinedStr) {
        String stubDataHex = null;
        try {
            stubDataHex = DCERPCMarshalling.marshalData(joinedStr);
        }
        catch (RPCMarshallingException ex) {
            log.error("Error in hexEncodeTextParts", (Throwable)ex);
        }
        stubDataHex = stubDataHex.replaceAll("[^0-9^a-f^A-F]", "");
        if (stubDataHex.length() % 2 != 0) {
            log.warn("Uneven hex, data will be trimmed to even: " + stubDataHex);
            stubDataHex = stubDataHex.substring(0, stubDataHex.length() - 1);
            stubDataHex = stubDataHex + JOrphanUtils.baToHexString((byte[])"!!!DATA WAS TRIMMED!!!".getBytes());
        }
        return stubDataHex;
    }

    public static RPCPacket[] getRequestsArrayByString(String paramsStr, String dataStr) {
        RPCPacket[] result;
        String[] fields = paramsStr.split("[\t ]");
        if (fields[0].toLowerCase().trim().equals("bind")) {
            if (fields.length < 3) {
                throw new IllegalArgumentException("Bind request requires 2 params: Interface UUID and Transfer Syntax");
            }
            result = new RPCBindRequest[]{new RPCBindRequest(fields[1], fields[2])};
        } else {
            if (fields.length < 2) {
                throw new IllegalArgumentException("Call requires 2 params: CallID and OpNum");
            }
            int callID = Integer.parseInt(fields[0]);
            short opNum = DCERPCSamplerUtils.getOpNum(fields[1]);
            String stubDataHex = DCERPCSamplerUtils.getStubDataHex(dataStr);
            byte[] stubDataByteArray = BinaryTCPClientImpl.hexStringToByteArray((String)stubDataHex);
            result = DCERPCSamplerUtils.getPacketsArray(stubDataByteArray, callID, opNum);
        }
        return result;
    }
}

